<?php

namespace Eurostop\Sales;

class GetReceiptsByBranchTillResolvedDateCustom
{

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var int $tillNumber
     */
    protected $tillNumber = null;

    /**
     * @var \DateTime $fromDate
     */
    protected $fromDate = null;

    /**
     * @var \DateTime $toDate
     */
    protected $toDate = null;

    /**
     * @var int $maxReceipts
     */
    protected $maxReceipts = null;

    /**
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param int $tillNumber
     * @param \DateTime $fromDate
     * @param \DateTime $toDate
     * @param int $maxReceipts
     */
    public function __construct($branchIdentifier, $branchIdentifierType, $tillNumber, \DateTime $fromDate, \DateTime $toDate, $maxReceipts)
    {
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->tillNumber = $tillNumber;
      $this->fromDate = $fromDate->format(\DateTime::ATOM);
      $this->toDate = $toDate->format(\DateTime::ATOM);
      $this->maxReceipts = $maxReceipts;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Sales\GetReceiptsByBranchTillResolvedDate
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Sales\GetReceiptsByBranchTillResolvedDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getTillNumber()
    {
      return $this->tillNumber;
    }

    /**
     * @param int $tillNumber
     * @return \Eurostop\Sales\GetReceiptsByBranchTillResolvedDate
     */
    public function setTillNumber($tillNumber)
    {
      $this->tillNumber = $tillNumber;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getFromDate()
    {
      if ($this->fromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->fromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $fromDate
     * @return \Eurostop\Sales\GetReceiptsByBranchTillResolvedDate
     */
    public function setFromDate(\DateTime $fromDate)
    {
      $this->fromDate = $fromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getToDate()
    {
      if ($this->toDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->toDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $toDate
     * @return \Eurostop\Sales\GetReceiptsByBranchTillResolvedDate
     */
    public function setToDate(\DateTime $toDate)
    {
      $this->toDate = $toDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxReceipts()
    {
      return $this->maxReceipts;
    }

    /**
     * @param int $maxReceipts
     * @return \Eurostop\Sales\GetReceiptsByBranchTillResolvedDate
     */
    public function setMaxReceipts($maxReceipts)
    {
      $this->maxReceipts = $maxReceipts;
      return $this;
    }

}
