<?php

namespace Eurostop\Sales;

class GetNextSerialisedVoucherNumbers
{

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var int $tillNumber
     */
    protected $tillNumber = null;

    /**
     * @var int $voucherCount
     */
    protected $voucherCount = null;

    /**
     * @var boolean $reserveVoucherNumbers
     */
    protected $reserveVoucherNumbers = null;

    /**
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param int $tillNumber
     * @param int $voucherCount
     * @param boolean $reserveVoucherNumbers
     */
    public function __construct($branchIdentifier, $branchIdentifierType, $tillNumber, $voucherCount, $reserveVoucherNumbers)
    {
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->tillNumber = $tillNumber;
      $this->voucherCount = $voucherCount;
      $this->reserveVoucherNumbers = $reserveVoucherNumbers;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Sales\GetNextSerialisedVoucherNumbers
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Sales\GetNextSerialisedVoucherNumbers
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getTillNumber()
    {
      return $this->tillNumber;
    }

    /**
     * @param int $tillNumber
     * @return \Eurostop\Sales\GetNextSerialisedVoucherNumbers
     */
    public function setTillNumber($tillNumber)
    {
      $this->tillNumber = $tillNumber;
      return $this;
    }

    /**
     * @return int
     */
    public function getVoucherCount()
    {
      return $this->voucherCount;
    }

    /**
     * @param int $voucherCount
     * @return \Eurostop\Sales\GetNextSerialisedVoucherNumbers
     */
    public function setVoucherCount($voucherCount)
    {
      $this->voucherCount = $voucherCount;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReserveVoucherNumbers()
    {
      return $this->reserveVoucherNumbers;
    }

    /**
     * @param boolean $reserveVoucherNumbers
     * @return \Eurostop\Sales\GetNextSerialisedVoucherNumbers
     */
    public function setReserveVoucherNumbers($reserveVoucherNumbers)
    {
      $this->reserveVoucherNumbers = $reserveVoucherNumbers;
      return $this;
    }

}
