<?php

namespace Eurostop\Sales;

class ArrayOfReceiptOperationCustom implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var ReceiptOperation[] $ReceiptOperation
     */
    protected $ReceiptOperation = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return ReceiptOperation[]
     */
    public function getReceiptOperation()
    {
      return $this->ReceiptOperation;
    }

    /**
     * @param ReceiptOperation[] $ReceiptOperation
     * @return \Eurostop\Sales\ArrayOfReceiptOperation
     */
    public function setReceiptOperation(array $ReceiptOperation = null)
    {
      $this->ReceiptOperation = $ReceiptOperation;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->ReceiptOperation[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return ReceiptOperation
     */
    public function offsetGet($offset)
    {
      return $this->ReceiptOperation[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param ReceiptOperation $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->ReceiptOperation[] = $value;
      } else {
        $this->ReceiptOperation[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->ReceiptOperation[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return ReceiptOperation Return the current element
     */
    public function current()
    {
      return current($this->ReceiptOperation);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->ReceiptOperation);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->ReceiptOperation);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->ReceiptOperation);
    }

    /**
     * Countable implementation
     *
     * @return ReceiptOperation Return count of elements
     */
    public function count()
    {
      return count($this->ReceiptOperation);
    }

}
