<?php

namespace Eurostop\Products;

class SubmitSkuAdditionalPrices
{

    /**
     * @var ArrayOfSubmittedSkuAdditionalPrice $skuAdditionalPrices
     */
    protected $skuAdditionalPrices = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedSkuAdditionalPrice $skuAdditionalPrices
     * @param string $submissionReference
     */
    public function __construct($skuAdditionalPrices, $submissionReference)
    {
      $this->skuAdditionalPrices = $skuAdditionalPrices;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedSkuAdditionalPrice
     */
    public function getSkuAdditionalPrices()
    {
      return $this->skuAdditionalPrices;
    }

    /**
     * @param ArrayOfSubmittedSkuAdditionalPrice $skuAdditionalPrices
     * @return \Eurostop\Products\SubmitSkuAdditionalPrices
     */
    public function setSkuAdditionalPrices($skuAdditionalPrices)
    {
      $this->skuAdditionalPrices = $skuAdditionalPrices;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSkuAdditionalPrices
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
