<?php

namespace Eurostop\Products;

class SubmitSizes
{

    /**
     * @var ArrayOfSubmittedSize $sizes
     */
    protected $sizes = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedSize $sizes
     * @param string $submissionReference
     */
    public function __construct($sizes, $submissionReference)
    {
      $this->sizes = $sizes;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedSize
     */
    public function getSizes()
    {
      return $this->sizes;
    }

    /**
     * @param ArrayOfSubmittedSize $sizes
     * @return \Eurostop\Products\SubmitSizes
     */
    public function setSizes($sizes)
    {
      $this->sizes = $sizes;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitSizes
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
