<?php

namespace Eurostop\Products;

class SubmitProducts
{

    /**
     * @var ArrayOfSubmittedProduct $products
     */
    protected $products = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedProduct $products
     * @param string $submissionReference
     */
    public function __construct($products, $submissionReference)
    {
      $this->products = $products;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedProduct
     */
    public function getProducts()
    {
      return $this->products;
    }

    /**
     * @param ArrayOfSubmittedProduct $products
     * @return \Eurostop\Products\SubmitProducts
     */
    public function setProducts($products)
    {
      $this->products = $products;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitProducts
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
