<?php

namespace Eurostop\Products;

class SubmitProduct
{

    /**
     * @var SubmittedProduct $product
     */
    protected $product = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedProduct $product
     * @param string $submissionReference
     */
    public function __construct($product, $submissionReference)
    {
      $this->product = $product;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedProduct
     */
    public function getProduct()
    {
      return $this->product;
    }

    /**
     * @param SubmittedProduct $product
     * @return \Eurostop\Products\SubmitProduct
     */
    public function setProduct($product)
    {
      $this->product = $product;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitProduct
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
