<?php

namespace Eurostop\Products;

class SubmitAnalysisValueAction
{

    /**
     * @var SubmittedAnalysisValueAction $analysisValueAction
     */
    protected $analysisValueAction = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedAnalysisValueAction $analysisValueAction
     * @param string $submissionReference
     */
    public function __construct($analysisValueAction, $submissionReference)
    {
      $this->analysisValueAction = $analysisValueAction;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedAnalysisValueAction
     */
    public function getAnalysisValueAction()
    {
      return $this->analysisValueAction;
    }

    /**
     * @param SubmittedAnalysisValueAction $analysisValueAction
     * @return \Eurostop\Products\SubmitAnalysisValueAction
     */
    public function setAnalysisValueAction($analysisValueAction)
    {
      $this->analysisValueAction = $analysisValueAction;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Products\SubmitAnalysisValueAction
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
