<?php

namespace Eurostop\Products;

class GetSupplier
{

    /**
     * @var string $supplierIdentifier
     */
    protected $supplierIdentifier = null;

    /**
     * @var SupplierIdentifierType $supplierIdentifierType
     */
    protected $supplierIdentifierType = null;

    /**
     * @param string $supplierIdentifier
     * @param SupplierIdentifierType $supplierIdentifierType
     */
    public function __construct($supplierIdentifier, $supplierIdentifierType)
    {
      $this->supplierIdentifier = $supplierIdentifier;
      $this->supplierIdentifierType = $supplierIdentifierType;
    }

    /**
     * @return string
     */
    public function getSupplierIdentifier()
    {
      return $this->supplierIdentifier;
    }

    /**
     * @param string $supplierIdentifier
     * @return \Eurostop\Products\GetSupplier
     */
    public function setSupplierIdentifier($supplierIdentifier)
    {
      $this->supplierIdentifier = $supplierIdentifier;
      return $this;
    }

    /**
     * @return SupplierIdentifierType
     */
    public function getSupplierIdentifierType()
    {
      return $this->supplierIdentifierType;
    }

    /**
     * @param SupplierIdentifierType $supplierIdentifierType
     * @return \Eurostop\Products\GetSupplier
     */
    public function setSupplierIdentifierType($supplierIdentifierType)
    {
      $this->supplierIdentifierType = $supplierIdentifierType;
      return $this;
    }

}
