<?php

namespace Eurostop\Products;

class GetSkuPricesByCountryAndProductAnalysisValueList
{

    /**
     * @var string $countryIdentifier
     */
    protected $countryIdentifier = null;

    /**
     * @var CountryIdentifierType $countryIdentifierType
     */
    protected $countryIdentifierType = null;

    /**
     * @var string $analysisTypeIdentifier
     */
    protected $analysisTypeIdentifier = null;

    /**
     * @var ArrayOfstring $analysisValueIdentifiers
     */
    protected $analysisValueIdentifiers = null;

    /**
     * @var AnalysisTypeIdentifierType $analysisTypeIdentifierType
     */
    protected $analysisTypeIdentifierType = null;

    /**
     * @var AnalysisValueIdentifierType $analysisValueIdentifierType
     */
    protected $analysisValueIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @param string $countryIdentifier
     * @param CountryIdentifierType $countryIdentifierType
     * @param string $analysisTypeIdentifier
     * @param ArrayOfstring $analysisValueIdentifiers
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @param \DateTime $modifiedSinceDate
     */
    public function __construct($countryIdentifier, $countryIdentifierType, $analysisTypeIdentifier, $analysisValueIdentifiers, $analysisTypeIdentifierType, $analysisValueIdentifierType, \DateTime $modifiedSinceDate)
    {
      $this->countryIdentifier = $countryIdentifier;
      $this->countryIdentifierType = $countryIdentifierType;
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      $this->analysisValueIdentifiers = $analysisValueIdentifiers;
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getCountryIdentifier()
    {
      return $this->countryIdentifier;
    }

    /**
     * @param string $countryIdentifier
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductAnalysisValueList
     */
    public function setCountryIdentifier($countryIdentifier)
    {
      $this->countryIdentifier = $countryIdentifier;
      return $this;
    }

    /**
     * @return CountryIdentifierType
     */
    public function getCountryIdentifierType()
    {
      return $this->countryIdentifierType;
    }

    /**
     * @param CountryIdentifierType $countryIdentifierType
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductAnalysisValueList
     */
    public function setCountryIdentifierType($countryIdentifierType)
    {
      $this->countryIdentifierType = $countryIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getAnalysisTypeIdentifier()
    {
      return $this->analysisTypeIdentifier;
    }

    /**
     * @param string $analysisTypeIdentifier
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductAnalysisValueList
     */
    public function setAnalysisTypeIdentifier($analysisTypeIdentifier)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getAnalysisValueIdentifiers()
    {
      return $this->analysisValueIdentifiers;
    }

    /**
     * @param ArrayOfstring $analysisValueIdentifiers
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductAnalysisValueList
     */
    public function setAnalysisValueIdentifiers($analysisValueIdentifiers)
    {
      $this->analysisValueIdentifiers = $analysisValueIdentifiers;
      return $this;
    }

    /**
     * @return AnalysisTypeIdentifierType
     */
    public function getAnalysisTypeIdentifierType()
    {
      return $this->analysisTypeIdentifierType;
    }

    /**
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductAnalysisValueList
     */
    public function setAnalysisTypeIdentifierType($analysisTypeIdentifierType)
    {
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      return $this;
    }

    /**
     * @return AnalysisValueIdentifierType
     */
    public function getAnalysisValueIdentifierType()
    {
      return $this->analysisValueIdentifierType;
    }

    /**
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductAnalysisValueList
     */
    public function setAnalysisValueIdentifierType($analysisValueIdentifierType)
    {
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Products\GetSkuPricesByCountryAndProductAnalysisValueList
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

}
