<?php

namespace Eurostop\Products;

class GetSizesBySizeGroup
{

    /**
     * @var string $sizeGroupIdentifier
     */
    protected $sizeGroupIdentifier = null;

    /**
     * @var SizeGroupIdentifierType $sizeGroupIdentifierType
     */
    protected $sizeGroupIdentifierType = null;

    /**
     * @var string $cultureCode
     */
    protected $cultureCode = null;

    /**
     * @param string $sizeGroupIdentifier
     * @param SizeGroupIdentifierType $sizeGroupIdentifierType
     * @param string $cultureCode
     */
    public function __construct($sizeGroupIdentifier, $sizeGroupIdentifierType, $cultureCode)
    {
      $this->sizeGroupIdentifier = $sizeGroupIdentifier;
      $this->sizeGroupIdentifierType = $sizeGroupIdentifierType;
      $this->cultureCode = $cultureCode;
    }

    /**
     * @return string
     */
    public function getSizeGroupIdentifier()
    {
      return $this->sizeGroupIdentifier;
    }

    /**
     * @param string $sizeGroupIdentifier
     * @return \Eurostop\Products\GetSizesBySizeGroup
     */
    public function setSizeGroupIdentifier($sizeGroupIdentifier)
    {
      $this->sizeGroupIdentifier = $sizeGroupIdentifier;
      return $this;
    }

    /**
     * @return SizeGroupIdentifierType
     */
    public function getSizeGroupIdentifierType()
    {
      return $this->sizeGroupIdentifierType;
    }

    /**
     * @param SizeGroupIdentifierType $sizeGroupIdentifierType
     * @return \Eurostop\Products\GetSizesBySizeGroup
     */
    public function setSizeGroupIdentifierType($sizeGroupIdentifierType)
    {
      $this->sizeGroupIdentifierType = $sizeGroupIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getCultureCode()
    {
      return $this->cultureCode;
    }

    /**
     * @param string $cultureCode
     * @return \Eurostop\Products\GetSizesBySizeGroup
     */
    public function setCultureCode($cultureCode)
    {
      $this->cultureCode = $cultureCode;
      return $this;
    }

}
