<?php

namespace Eurostop\Products;

class GetProductsByAnalysisValueList
{

    /**
     * @var string $analysisTypeIdentifier
     */
    protected $analysisTypeIdentifier = null;

    /**
     * @var ArrayOfstring $analysisValueIdentifiers
     */
    protected $analysisValueIdentifiers = null;

    /**
     * @var AnalysisTypeIdentifierType $analysisTypeIdentifierType
     */
    protected $analysisTypeIdentifierType = null;

    /**
     * @var AnalysisValueIdentifierType $analysisValueIdentifierType
     */
    protected $analysisValueIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $returnAnalysisValues
     */
    protected $returnAnalysisValues = null;

    /**
     * @var boolean $returnExtendedAttributeValues
     */
    protected $returnExtendedAttributeValues = null;

    /**
     * @var string $cultureCode
     */
    protected $cultureCode = null;

    /**
     * @var \DateTime $modifiedUntilDate
     */
    protected $modifiedUntilDate = null;

    /**
     * @param string $analysisTypeIdentifier
     * @param ArrayOfstring $analysisValueIdentifiers
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $returnAnalysisValues
     * @param boolean $returnExtendedAttributeValues
     * @param string $cultureCode
     * @param \DateTime $modifiedUntilDate
     */
    public function __construct($analysisTypeIdentifier, $analysisValueIdentifiers, $analysisTypeIdentifierType, $analysisValueIdentifierType, \DateTime $modifiedSinceDate, $returnAnalysisValues, $returnExtendedAttributeValues, $cultureCode, \DateTime $modifiedUntilDate)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      $this->analysisValueIdentifiers = $analysisValueIdentifiers;
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->returnAnalysisValues = $returnAnalysisValues;
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      $this->cultureCode = $cultureCode;
      $this->modifiedUntilDate = $modifiedUntilDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getAnalysisTypeIdentifier()
    {
      return $this->analysisTypeIdentifier;
    }

    /**
     * @param string $analysisTypeIdentifier
     * @return \Eurostop\Products\GetProductsByAnalysisValueList
     */
    public function setAnalysisTypeIdentifier($analysisTypeIdentifier)
    {
      $this->analysisTypeIdentifier = $analysisTypeIdentifier;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getAnalysisValueIdentifiers()
    {
      return $this->analysisValueIdentifiers;
    }

    /**
     * @param ArrayOfstring $analysisValueIdentifiers
     * @return \Eurostop\Products\GetProductsByAnalysisValueList
     */
    public function setAnalysisValueIdentifiers($analysisValueIdentifiers)
    {
      $this->analysisValueIdentifiers = $analysisValueIdentifiers;
      return $this;
    }

    /**
     * @return AnalysisTypeIdentifierType
     */
    public function getAnalysisTypeIdentifierType()
    {
      return $this->analysisTypeIdentifierType;
    }

    /**
     * @param AnalysisTypeIdentifierType $analysisTypeIdentifierType
     * @return \Eurostop\Products\GetProductsByAnalysisValueList
     */
    public function setAnalysisTypeIdentifierType($analysisTypeIdentifierType)
    {
      $this->analysisTypeIdentifierType = $analysisTypeIdentifierType;
      return $this;
    }

    /**
     * @return AnalysisValueIdentifierType
     */
    public function getAnalysisValueIdentifierType()
    {
      return $this->analysisValueIdentifierType;
    }

    /**
     * @param AnalysisValueIdentifierType $analysisValueIdentifierType
     * @return \Eurostop\Products\GetProductsByAnalysisValueList
     */
    public function setAnalysisValueIdentifierType($analysisValueIdentifierType)
    {
      $this->analysisValueIdentifierType = $analysisValueIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Products\GetProductsByAnalysisValueList
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnAnalysisValues()
    {
      return $this->returnAnalysisValues;
    }

    /**
     * @param boolean $returnAnalysisValues
     * @return \Eurostop\Products\GetProductsByAnalysisValueList
     */
    public function setReturnAnalysisValues($returnAnalysisValues)
    {
      $this->returnAnalysisValues = $returnAnalysisValues;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getReturnExtendedAttributeValues()
    {
      return $this->returnExtendedAttributeValues;
    }

    /**
     * @param boolean $returnExtendedAttributeValues
     * @return \Eurostop\Products\GetProductsByAnalysisValueList
     */
    public function setReturnExtendedAttributeValues($returnExtendedAttributeValues)
    {
      $this->returnExtendedAttributeValues = $returnExtendedAttributeValues;
      return $this;
    }

    /**
     * @return string
     */
    public function getCultureCode()
    {
      return $this->cultureCode;
    }

    /**
     * @param string $cultureCode
     * @return \Eurostop\Products\GetProductsByAnalysisValueList
     */
    public function setCultureCode($cultureCode)
    {
      $this->cultureCode = $cultureCode;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedUntilDate()
    {
      if ($this->modifiedUntilDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedUntilDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedUntilDate
     * @return \Eurostop\Products\GetProductsByAnalysisValueList
     */
    public function setModifiedUntilDate(\DateTime $modifiedUntilDate)
    {
      $this->modifiedUntilDate = $modifiedUntilDate->format(\DateTime::ATOM);
      return $this;
    }

}
