<?php

namespace Eurostop\Products;

class GetColoursBySeason
{

    /**
     * @var string $seasonIdentifier
     */
    protected $seasonIdentifier = null;

    /**
     * @var HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     */
    protected $hierarchyNodeIdentifierType = null;

    /**
     * @var string $cultureCode
     */
    protected $cultureCode = null;

    /**
     * @param string $seasonIdentifier
     * @param HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     * @param string $cultureCode
     */
    public function __construct($seasonIdentifier, $hierarchyNodeIdentifierType, $cultureCode)
    {
      $this->seasonIdentifier = $seasonIdentifier;
      $this->hierarchyNodeIdentifierType = $hierarchyNodeIdentifierType;
      $this->cultureCode = $cultureCode;
    }

    /**
     * @return string
     */
    public function getSeasonIdentifier()
    {
      return $this->seasonIdentifier;
    }

    /**
     * @param string $seasonIdentifier
     * @return \Eurostop\Products\GetColoursBySeason
     */
    public function setSeasonIdentifier($seasonIdentifier)
    {
      $this->seasonIdentifier = $seasonIdentifier;
      return $this;
    }

    /**
     * @return HierarchyNodeIdentifierType
     */
    public function getHierarchyNodeIdentifierType()
    {
      return $this->hierarchyNodeIdentifierType;
    }

    /**
     * @param HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     * @return \Eurostop\Products\GetColoursBySeason
     */
    public function setHierarchyNodeIdentifierType($hierarchyNodeIdentifierType)
    {
      $this->hierarchyNodeIdentifierType = $hierarchyNodeIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getCultureCode()
    {
      return $this->cultureCode;
    }

    /**
     * @param string $cultureCode
     * @return \Eurostop\Products\GetColoursBySeason
     */
    public function setCultureCode($cultureCode)
    {
      $this->cultureCode = $cultureCode;
      return $this;
    }

}
