<?php

namespace Eurostop\Products;

class BranchSkuTax extends RetrievedDataItemOfBranchSkuTaxDtoVNxenGD6
{

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var boolean $Enabled
     */
    protected $Enabled = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var float $TaxRate
     */
    protected $TaxRate = null;

    /**
     * @var float $TaxValueThreshold
     */
    protected $TaxValueThreshold = null;

    /**
     * @param boolean $Enabled
     * @param float $TaxRate
     * @param float $TaxValueThreshold
     */
    public function __construct($Enabled, $TaxRate, $TaxValueThreshold)
    {
      parent::__construct();
      $this->Enabled = $Enabled;
      $this->TaxRate = $TaxRate;
      $this->TaxValueThreshold = $TaxValueThreshold;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Products\BranchSkuTax
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getEnabled()
    {
      return $this->Enabled;
    }

    /**
     * @param boolean $Enabled
     * @return \Eurostop\Products\BranchSkuTax
     */
    public function setEnabled($Enabled)
    {
      $this->Enabled = $Enabled;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Products\BranchSkuTax
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getTaxRate()
    {
      return $this->TaxRate;
    }

    /**
     * @param float $TaxRate
     * @return \Eurostop\Products\BranchSkuTax
     */
    public function setTaxRate($TaxRate)
    {
      $this->TaxRate = $TaxRate;
      return $this;
    }

    /**
     * @return float
     */
    public function getTaxValueThreshold()
    {
      return $this->TaxValueThreshold;
    }

    /**
     * @param float $TaxValueThreshold
     * @return \Eurostop\Products\BranchSkuTax
     */
    public function setTaxValueThreshold($TaxValueThreshold)
    {
      $this->TaxValueThreshold = $TaxValueThreshold;
      return $this;
    }

}
