<?php

namespace Eurostop\Products;

class ArrayOfSize implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var Size[] $Size
     */
    protected $Size = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return Size[]
     */
    public function getSize()
    {
      return $this->Size;
    }

    /**
     * @param Size[] $Size
     * @return \Eurostop\Products\ArrayOfSize
     */
    public function setSize(array $Size = null)
    {
      $this->Size = $Size;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->Size[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return Size
     */
    public function offsetGet($offset)
    {
      return $this->Size[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param Size $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->Size[] = $value;
      } else {
        $this->Size[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->Size[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return Size Return the current element
     */
    public function current()
    {
      return current($this->Size);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->Size);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->Size);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->Size);
    }

    /**
     * Countable implementation
     *
     * @return Size Return count of elements
     */
    public function count()
    {
      return count($this->Size);
    }

}
