<?php

namespace Eurostop\Products;

class ArrayOfAnalysisType implements \ArrayAccess, \Iterator, \Countable
{

    /**
     * @var AnalysisType[] $AnalysisType
     */
    protected $AnalysisType = null;

    
    public function __construct()
    {
    
    }

    /**
     * @return AnalysisType[]
     */
    public function getAnalysisType()
    {
      return $this->AnalysisType;
    }

    /**
     * @param AnalysisType[] $AnalysisType
     * @return \Eurostop\Products\ArrayOfAnalysisType
     */
    public function setAnalysisType(array $AnalysisType = null)
    {
      $this->AnalysisType = $AnalysisType;
      return $this;
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset An offset to check for
     * @return boolean true on success or false on failure
     */
    public function offsetExists($offset)
    {
      return isset($this->AnalysisType[$offset]);
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to retrieve
     * @return AnalysisType
     */
    public function offsetGet($offset)
    {
      return $this->AnalysisType[$offset];
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to assign the value to
     * @param AnalysisType $value The value to set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
      if (!isset($offset)) {
        $this->AnalysisType[] = $value;
      } else {
        $this->AnalysisType[$offset] = $value;
      }
    }

    /**
     * ArrayAccess implementation
     *
     * @param mixed $offset The offset to unset
     * @return void
     */
    public function offsetUnset($offset)
    {
      unset($this->AnalysisType[$offset]);
    }

    /**
     * Iterator implementation
     *
     * @return AnalysisType Return the current element
     */
    public function current()
    {
      return current($this->AnalysisType);
    }

    /**
     * Iterator implementation
     * Move forward to next element
     *
     * @return void
     */
    public function next()
    {
      next($this->AnalysisType);
    }

    /**
     * Iterator implementation
     *
     * @return string|null Return the key of the current element or null
     */
    public function key()
    {
      return key($this->AnalysisType);
    }

    /**
     * Iterator implementation
     *
     * @return boolean Return the validity of the current position
     */
    public function valid()
    {
      return $this->key() !== null;
    }

    /**
     * Iterator implementation
     * Rewind the Iterator to the first element
     *
     * @return void
     */
    public function rewind()
    {
      reset($this->AnalysisType);
    }

    /**
     * Countable implementation
     *
     * @return AnalysisType Return count of elements
     */
    public function count()
    {
      return count($this->AnalysisType);
    }

}
