<?php

namespace Eurostop\Organisation;

class VatRateCustom extends CodedRetrievedDataItemOfVatRateDtoTPKTiFnXCustom
{

    /**
     * @var string $CountryIdentifier
     */
    protected $CountryIdentifier = null;

    /**
     * @var string $Description
     */
    protected $Description = null;

    /**
     * @var string $EquivalentVatRateIdentifier
     */
    protected $EquivalentVatRateIdentifier = null;

    /**
     * @var float $PercentageRate
     */
    protected $PercentageRate = null;

    /**
     * @var string $TaxGroupID
     */
    protected $TaxGroupID = null;

    /**
     * @var string $TaxRuleName
     */
    protected $TaxRuleName = null;

    /**
     * @param float $PercentageRate
     */
    public function __construct($PercentageRate)
    {
      parent::__construct();
      $this->PercentageRate = $PercentageRate;
    }

    /**
     * @return string
     */
    public function getCountryIdentifier()
    {
      return $this->CountryIdentifier;
    }

    /**
     * @param string $CountryIdentifier
     * @return \Eurostop\Organisation\VatRate
     */
    public function setCountryIdentifier($CountryIdentifier)
    {
      $this->CountryIdentifier = $CountryIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getDescription()
    {
      return $this->Description;
    }

    /**
     * @param string $Description
     * @return \Eurostop\Organisation\VatRate
     */
    public function setDescription($Description)
    {
      $this->Description = $Description;
      return $this;
    }

    /**
     * @return string
     */
    public function getEquivalentVatRateIdentifier()
    {
      return $this->EquivalentVatRateIdentifier;
    }

    /**
     * @param string $EquivalentVatRateIdentifier
     * @return \Eurostop\Organisation\VatRate
     */
    public function setEquivalentVatRateIdentifier($EquivalentVatRateIdentifier)
    {
      $this->EquivalentVatRateIdentifier = $EquivalentVatRateIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getPercentageRate()
    {
      return $this->PercentageRate;
    }

    /**
     * @param float $PercentageRate
     * @return \Eurostop\Organisation\VatRate
     */
    public function setPercentageRate($PercentageRate)
    {
      $this->PercentageRate = $PercentageRate;
      return $this;
    }

    /**
     * @return string
     */
    public function getTaxGroupID()
    {
      return $this->TaxGroupID;
    }

    /**
     * @param string $TaxGroupID
     * @return \Eurostop\Organisation\VatRate
     */
    public function setTaxGroupID($TaxGroupID)
    {
      $this->TaxGroupID = $TaxGroupID;
      return $this;
    }

    /**
     * @return string
     */
    public function getTaxRuleName()
    {
      return $this->TaxRuleName;
    }

    /**
     * @param string $TaxRuleName
     * @return \Eurostop\Organisation\VatRate
     */
    public function setTaxRuleName($TaxRuleName)
    {
      $this->TaxRuleName = $TaxRuleName;
      return $this;
    }

}
