<?php

namespace Eurostop\Organisation;

class CurrencyConversionCustom extends RetrievedDataItemOfCurrencyConversionDtoTPKTiFnXCustom
{

    /**
     * @var \DateTime $EffectiveDate
     */
    protected $EffectiveDate = null;

    /**
     * @var float $ExchangeRate
     */
    protected $ExchangeRate = null;

    /**
     * @var string $FromCurrencyIdentifier
     */
    protected $FromCurrencyIdentifier = null;

    /**
     * @var string $ToCurrencyIdentifier
     */
    protected $ToCurrencyIdentifier = null;

    /**
     * @param \DateTime $EffectiveDate
     * @param float $ExchangeRate
     */
    public function __construct(\DateTime $EffectiveDate, $ExchangeRate)
    {
      parent::__construct();
      $this->EffectiveDate = $EffectiveDate->format(\DateTime::ATOM);
      $this->ExchangeRate = $ExchangeRate;
    }

    /**
     * @return \DateTime
     */
    public function getEffectiveDate()
    {
      if ($this->EffectiveDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->EffectiveDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $EffectiveDate
     * @return \Eurostop\Organisation\CurrencyConversion
     */
    public function setEffectiveDate(\DateTime $EffectiveDate)
    {
      $this->EffectiveDate = $EffectiveDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return float
     */
    public function getExchangeRate()
    {
      return $this->ExchangeRate;
    }

    /**
     * @param float $ExchangeRate
     * @return \Eurostop\Organisation\CurrencyConversion
     */
    public function setExchangeRate($ExchangeRate)
    {
      $this->ExchangeRate = $ExchangeRate;
      return $this;
    }

    /**
     * @return string
     */
    public function getFromCurrencyIdentifier()
    {
      return $this->FromCurrencyIdentifier;
    }

    /**
     * @param string $FromCurrencyIdentifier
     * @return \Eurostop\Organisation\CurrencyConversion
     */
    public function setFromCurrencyIdentifier($FromCurrencyIdentifier)
    {
      $this->FromCurrencyIdentifier = $FromCurrencyIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getToCurrencyIdentifier()
    {
      return $this->ToCurrencyIdentifier;
    }

    /**
     * @param string $ToCurrencyIdentifier
     * @return \Eurostop\Organisation\CurrencyConversion
     */
    public function setToCurrencyIdentifier($ToCurrencyIdentifier)
    {
      $this->ToCurrencyIdentifier = $ToCurrencyIdentifier;
      return $this;
    }

}
