<?php

namespace Eurostop\Loyalty;

class SubmitCustomerCustom
{

    /**
     * @var SubmittedCustomer $customer
     */
    protected $customer = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedCustomer $customer
     * @param string $submissionReference
     */
    public function __construct($customer, $submissionReference)
    {
      $this->customer = $customer;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedCustomer
     */
    public function getCustomer()
    {
      return $this->customer;
    }

    /**
     * @param SubmittedCustomer $customer
     * @return \Eurostop\Loyalty\SubmitCustomer
     */
    public function setCustomer($customer)
    {
      $this->customer = $customer;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Loyalty\SubmitCustomer
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
