<?php

namespace Eurostop\Loyalty;

class CustomerAccountType extends CodedRetrievedDataItemOfCustomerAccountTypeDtoKJ8WzcEX
{

    /**
     * @var int $AccountGroup
     */
    protected $AccountGroup = null;

    /**
     * @var string $AccountNumberTemplate
     */
    protected $AccountNumberTemplate = null;

    /**
     * @var string $FirstUnassignedAccount
     */
    protected $FirstUnassignedAccount = null;

    /**
     * @var boolean $HasPreGeneratedNumbers
     */
    protected $HasPreGeneratedNumbers = null;

    /**
     * @var boolean $IsAutoAssigned
     */
    protected $IsAutoAssigned = null;

    /**
     * @var boolean $IsStaffAccount
     */
    protected $IsStaffAccount = null;

    /**
     * @var string $LastUnassignedAccount
     */
    protected $LastUnassignedAccount = null;

    /**
     * @param int $AccountGroup
     * @param boolean $HasPreGeneratedNumbers
     * @param boolean $IsAutoAssigned
     * @param boolean $IsStaffAccount
     */
    public function __construct($AccountGroup, $HasPreGeneratedNumbers, $IsAutoAssigned, $IsStaffAccount)
    {
      parent::__construct();
      $this->AccountGroup = $AccountGroup;
      $this->HasPreGeneratedNumbers = $HasPreGeneratedNumbers;
      $this->IsAutoAssigned = $IsAutoAssigned;
      $this->IsStaffAccount = $IsStaffAccount;
    }

    /**
     * @return int
     */
    public function getAccountGroup()
    {
      return $this->AccountGroup;
    }

    /**
     * @param int $AccountGroup
     * @return \Eurostop\Loyalty\CustomerAccountType
     */
    public function setAccountGroup($AccountGroup)
    {
      $this->AccountGroup = $AccountGroup;
      return $this;
    }

    /**
     * @return string
     */
    public function getAccountNumberTemplate()
    {
      return $this->AccountNumberTemplate;
    }

    /**
     * @param string $AccountNumberTemplate
     * @return \Eurostop\Loyalty\CustomerAccountType
     */
    public function setAccountNumberTemplate($AccountNumberTemplate)
    {
      $this->AccountNumberTemplate = $AccountNumberTemplate;
      return $this;
    }

    /**
     * @return string
     */
    public function getFirstUnassignedAccount()
    {
      return $this->FirstUnassignedAccount;
    }

    /**
     * @param string $FirstUnassignedAccount
     * @return \Eurostop\Loyalty\CustomerAccountType
     */
    public function setFirstUnassignedAccount($FirstUnassignedAccount)
    {
      $this->FirstUnassignedAccount = $FirstUnassignedAccount;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getHasPreGeneratedNumbers()
    {
      return $this->HasPreGeneratedNumbers;
    }

    /**
     * @param boolean $HasPreGeneratedNumbers
     * @return \Eurostop\Loyalty\CustomerAccountType
     */
    public function setHasPreGeneratedNumbers($HasPreGeneratedNumbers)
    {
      $this->HasPreGeneratedNumbers = $HasPreGeneratedNumbers;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsAutoAssigned()
    {
      return $this->IsAutoAssigned;
    }

    /**
     * @param boolean $IsAutoAssigned
     * @return \Eurostop\Loyalty\CustomerAccountType
     */
    public function setIsAutoAssigned($IsAutoAssigned)
    {
      $this->IsAutoAssigned = $IsAutoAssigned;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsStaffAccount()
    {
      return $this->IsStaffAccount;
    }

    /**
     * @param boolean $IsStaffAccount
     * @return \Eurostop\Loyalty\CustomerAccountType
     */
    public function setIsStaffAccount($IsStaffAccount)
    {
      $this->IsStaffAccount = $IsStaffAccount;
      return $this;
    }

    /**
     * @return string
     */
    public function getLastUnassignedAccount()
    {
      return $this->LastUnassignedAccount;
    }

    /**
     * @param string $LastUnassignedAccount
     * @return \Eurostop\Loyalty\CustomerAccountType
     */
    public function setLastUnassignedAccount($LastUnassignedAccount)
    {
      $this->LastUnassignedAccount = $LastUnassignedAccount;
      return $this;
    }

}
