<?php

namespace Eurostop\Fulfilment;

class SubmittedCustomerOrder extends SubmittedDataItemOfSubmittedCustomerOrderDtoHay9ORuz
{

    /**
     * @var SubmittedCustomerAddress $BillingAddress
     */
    protected $BillingAddress = null;

    /**
     * @var string $Comments
     */
    protected $Comments = null;

    /**
     * @var SubmittedCustomer $Customer
     */
    protected $Customer = null;

    /**
     * @var string $CustomerIdentifier
     */
    protected $CustomerIdentifier = null;

    /**
     * @var CustomerIdentifierType $CustomerIdentifierType
     */
    protected $CustomerIdentifierType = null;

    /**
     * @var string $CustomerNotes1
     */
    protected $CustomerNotes1 = null;

    /**
     * @var string $CustomerNotes2
     */
    protected $CustomerNotes2 = null;

    /**
     * @var float $CustomsValue
     */
    protected $CustomsValue = null;

    /**
     * @var SubmittedCustomerAddress $DeliveryAddress
     */
    protected $DeliveryAddress = null;

    /**
     * @var string $DeliveryAgentCode
     */
    protected $DeliveryAgentCode = null;

    /**
     * @var float $DeliveryChargeValue
     */
    protected $DeliveryChargeValue = null;

    /**
     * @var string $DeliveryInformation
     */
    protected $DeliveryInformation = null;

    /**
     * @var string $DeliveryInstructions1
     */
    protected $DeliveryInstructions1 = null;

    /**
     * @var string $DeliveryInstructions2
     */
    protected $DeliveryInstructions2 = null;

    /**
     * @var string $DeliveryMethodCode
     */
    protected $DeliveryMethodCode = null;

    /**
     * @var string $DeliveryServiceCode
     */
    protected $DeliveryServiceCode = null;

    /**
     * @var float $DeliveryVatValue
     */
    protected $DeliveryVatValue = null;

    /**
     * @var ArrayOfSubmittedCustomerOrderLine $Lines
     */
    protected $Lines = null;

    /**
     * @var \DateTime $OrderCreationDate
     */
    protected $OrderCreationDate = null;

    /**
     * @var string $OrderIdentifier
     */
    protected $OrderIdentifier = null;

    /**
     * @var CustomerOrderIdentifierType $OrderIdentifierType
     */
    protected $OrderIdentifierType = null;

    /**
     * @var string $ReceipientContactName
     */
    protected $ReceipientContactName = null;

    /**
     * @var string $ReceipientEmail
     */
    protected $ReceipientEmail = null;

    /**
     * @var string $ReceipientPhoneNumber1
     */
    protected $ReceipientPhoneNumber1 = null;

    /**
     * @var string $ReceipientPhoneNumber2
     */
    protected $ReceipientPhoneNumber2 = null;

    /**
     * @var string $Reference1
     */
    protected $Reference1 = null;

    /**
     * @var string $Reference2
     */
    protected $Reference2 = null;

    /**
     * @var string $SaleBranchIdentifier
     */
    protected $SaleBranchIdentifier = null;

    /**
     * @var BranchIdentifierType $SaleBranchIdentifierType
     */
    protected $SaleBranchIdentifierType = null;

    /**
     * @var string $UserDefinedData1
     */
    protected $UserDefinedData1 = null;

    /**
     * @var string $UserDefinedData2
     */
    protected $UserDefinedData2 = null;

    /**
     * @var string $UserDefinedData3
     */
    protected $UserDefinedData3 = null;

    /**
     * @var string $UserDefinedData4
     */
    protected $UserDefinedData4 = null;

    /**
     * @var string $UserDefinedData5
     */
    protected $UserDefinedData5 = null;

    /**
     * @var ArrayOfSubmittedCustomerOrderSourcingDirective $SourcingDirectives
     */
    protected $SourcingDirectives = null;

    /**
     * @param float $DeliveryChargeValue
     * @param float $DeliveryVatValue
     * @param \DateTime $OrderCreationDate
     * @param CustomerOrderIdentifierType $OrderIdentifierType
     */
    public function __construct($DeliveryChargeValue, $DeliveryVatValue, \DateTime $OrderCreationDate, $OrderIdentifierType)
    {
      parent::__construct();
      $this->DeliveryChargeValue = $DeliveryChargeValue;
      $this->DeliveryVatValue = $DeliveryVatValue;
      $this->OrderCreationDate = $OrderCreationDate->format(\DateTime::ATOM);
      $this->OrderIdentifierType = $OrderIdentifierType;
    }

    /**
     * @return SubmittedCustomerAddress
     */
    public function getBillingAddress()
    {
      return $this->BillingAddress;
    }

    /**
     * @param SubmittedCustomerAddress $BillingAddress
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setBillingAddress($BillingAddress)
    {
      $this->BillingAddress = $BillingAddress;
      return $this;
    }

    /**
     * @return string
     */
    public function getComments()
    {
      return $this->Comments;
    }

    /**
     * @param string $Comments
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setComments($Comments)
    {
      $this->Comments = $Comments;
      return $this;
    }

    /**
     * @return SubmittedCustomer
     */
    public function getCustomer()
    {
      return $this->Customer;
    }

    /**
     * @param SubmittedCustomer $Customer
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setCustomer($Customer)
    {
      $this->Customer = $Customer;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerIdentifier()
    {
      return $this->CustomerIdentifier;
    }

    /**
     * @param string $CustomerIdentifier
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setCustomerIdentifier($CustomerIdentifier)
    {
      $this->CustomerIdentifier = $CustomerIdentifier;
      return $this;
    }

    /**
     * @return CustomerIdentifierType
     */
    public function getCustomerIdentifierType()
    {
      return $this->CustomerIdentifierType;
    }

    /**
     * @param CustomerIdentifierType $CustomerIdentifierType
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setCustomerIdentifierType($CustomerIdentifierType)
    {
      $this->CustomerIdentifierType = $CustomerIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerNotes1()
    {
      return $this->CustomerNotes1;
    }

    /**
     * @param string $CustomerNotes1
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setCustomerNotes1($CustomerNotes1)
    {
      $this->CustomerNotes1 = $CustomerNotes1;
      return $this;
    }

    /**
     * @return string
     */
    public function getCustomerNotes2()
    {
      return $this->CustomerNotes2;
    }

    /**
     * @param string $CustomerNotes2
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setCustomerNotes2($CustomerNotes2)
    {
      $this->CustomerNotes2 = $CustomerNotes2;
      return $this;
    }

    /**
     * @return float
     */
    public function getCustomsValue()
    {
      return $this->CustomsValue;
    }

    /**
     * @param float $CustomsValue
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setCustomsValue($CustomsValue)
    {
      $this->CustomsValue = $CustomsValue;
      return $this;
    }

    /**
     * @return SubmittedCustomerAddress
     */
    public function getDeliveryAddress()
    {
      return $this->DeliveryAddress;
    }

    /**
     * @param SubmittedCustomerAddress $DeliveryAddress
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setDeliveryAddress($DeliveryAddress)
    {
      $this->DeliveryAddress = $DeliveryAddress;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryAgentCode()
    {
      return $this->DeliveryAgentCode;
    }

    /**
     * @param string $DeliveryAgentCode
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setDeliveryAgentCode($DeliveryAgentCode)
    {
      $this->DeliveryAgentCode = $DeliveryAgentCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getDeliveryChargeValue()
    {
      return $this->DeliveryChargeValue;
    }

    /**
     * @param float $DeliveryChargeValue
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setDeliveryChargeValue($DeliveryChargeValue)
    {
      $this->DeliveryChargeValue = $DeliveryChargeValue;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryInformation()
    {
      return $this->DeliveryInformation;
    }

    /**
     * @param string $DeliveryInformation
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setDeliveryInformation($DeliveryInformation)
    {
      $this->DeliveryInformation = $DeliveryInformation;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryInstructions1()
    {
      return $this->DeliveryInstructions1;
    }

    /**
     * @param string $DeliveryInstructions1
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setDeliveryInstructions1($DeliveryInstructions1)
    {
      $this->DeliveryInstructions1 = $DeliveryInstructions1;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryInstructions2()
    {
      return $this->DeliveryInstructions2;
    }

    /**
     * @param string $DeliveryInstructions2
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setDeliveryInstructions2($DeliveryInstructions2)
    {
      $this->DeliveryInstructions2 = $DeliveryInstructions2;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryMethodCode()
    {
      return $this->DeliveryMethodCode;
    }

    /**
     * @param string $DeliveryMethodCode
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setDeliveryMethodCode($DeliveryMethodCode)
    {
      $this->DeliveryMethodCode = $DeliveryMethodCode;
      return $this;
    }

    /**
     * @return string
     */
    public function getDeliveryServiceCode()
    {
      return $this->DeliveryServiceCode;
    }

    /**
     * @param string $DeliveryServiceCode
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setDeliveryServiceCode($DeliveryServiceCode)
    {
      $this->DeliveryServiceCode = $DeliveryServiceCode;
      return $this;
    }

    /**
     * @return float
     */
    public function getDeliveryVatValue()
    {
      return $this->DeliveryVatValue;
    }

    /**
     * @param float $DeliveryVatValue
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setDeliveryVatValue($DeliveryVatValue)
    {
      $this->DeliveryVatValue = $DeliveryVatValue;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedCustomerOrderLine
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfSubmittedCustomerOrderLine $Lines
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getOrderCreationDate()
    {
      if ($this->OrderCreationDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->OrderCreationDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $OrderCreationDate
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setOrderCreationDate(\DateTime $OrderCreationDate)
    {
      $this->OrderCreationDate = $OrderCreationDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getOrderIdentifier()
    {
      return $this->OrderIdentifier;
    }

    /**
     * @param string $OrderIdentifier
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setOrderIdentifier($OrderIdentifier)
    {
      $this->OrderIdentifier = $OrderIdentifier;
      return $this;
    }

    /**
     * @return CustomerOrderIdentifierType
     */
    public function getOrderIdentifierType()
    {
      return $this->OrderIdentifierType;
    }

    /**
     * @param CustomerOrderIdentifierType $OrderIdentifierType
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setOrderIdentifierType($OrderIdentifierType)
    {
      $this->OrderIdentifierType = $OrderIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getReceipientContactName()
    {
      return $this->ReceipientContactName;
    }

    /**
     * @param string $ReceipientContactName
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setReceipientContactName($ReceipientContactName)
    {
      $this->ReceipientContactName = $ReceipientContactName;
      return $this;
    }

    /**
     * @return string
     */
    public function getReceipientEmail()
    {
      return $this->ReceipientEmail;
    }

    /**
     * @param string $ReceipientEmail
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setReceipientEmail($ReceipientEmail)
    {
      $this->ReceipientEmail = $ReceipientEmail;
      return $this;
    }

    /**
     * @return string
     */
    public function getReceipientPhoneNumber1()
    {
      return $this->ReceipientPhoneNumber1;
    }

    /**
     * @param string $ReceipientPhoneNumber1
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setReceipientPhoneNumber1($ReceipientPhoneNumber1)
    {
      $this->ReceipientPhoneNumber1 = $ReceipientPhoneNumber1;
      return $this;
    }

    /**
     * @return string
     */
    public function getReceipientPhoneNumber2()
    {
      return $this->ReceipientPhoneNumber2;
    }

    /**
     * @param string $ReceipientPhoneNumber2
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setReceipientPhoneNumber2($ReceipientPhoneNumber2)
    {
      $this->ReceipientPhoneNumber2 = $ReceipientPhoneNumber2;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference1()
    {
      return $this->Reference1;
    }

    /**
     * @param string $Reference1
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setReference1($Reference1)
    {
      $this->Reference1 = $Reference1;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference2()
    {
      return $this->Reference2;
    }

    /**
     * @param string $Reference2
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setReference2($Reference2)
    {
      $this->Reference2 = $Reference2;
      return $this;
    }

    /**
     * @return string
     */
    public function getSaleBranchIdentifier()
    {
      return $this->SaleBranchIdentifier;
    }

    /**
     * @param string $SaleBranchIdentifier
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setSaleBranchIdentifier($SaleBranchIdentifier)
    {
      $this->SaleBranchIdentifier = $SaleBranchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getSaleBranchIdentifierType()
    {
      return $this->SaleBranchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $SaleBranchIdentifierType
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setSaleBranchIdentifierType($SaleBranchIdentifierType)
    {
      $this->SaleBranchIdentifierType = $SaleBranchIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getUserDefinedData1()
    {
      return $this->UserDefinedData1;
    }

    /**
     * @param string $UserDefinedData1
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setUserDefinedData1($UserDefinedData1)
    {
      $this->UserDefinedData1 = $UserDefinedData1;
      return $this;
    }

    /**
     * @return string
     */
    public function getUserDefinedData2()
    {
      return $this->UserDefinedData2;
    }

    /**
     * @param string $UserDefinedData2
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setUserDefinedData2($UserDefinedData2)
    {
      $this->UserDefinedData2 = $UserDefinedData2;
      return $this;
    }

    /**
     * @return string
     */
    public function getUserDefinedData3()
    {
      return $this->UserDefinedData3;
    }

    /**
     * @param string $UserDefinedData3
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setUserDefinedData3($UserDefinedData3)
    {
      $this->UserDefinedData3 = $UserDefinedData3;
      return $this;
    }

    /**
     * @return string
     */
    public function getUserDefinedData4()
    {
      return $this->UserDefinedData4;
    }

    /**
     * @param string $UserDefinedData4
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setUserDefinedData4($UserDefinedData4)
    {
      $this->UserDefinedData4 = $UserDefinedData4;
      return $this;
    }

    /**
     * @return string
     */
    public function getUserDefinedData5()
    {
      return $this->UserDefinedData5;
    }

    /**
     * @param string $UserDefinedData5
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setUserDefinedData5($UserDefinedData5)
    {
      $this->UserDefinedData5 = $UserDefinedData5;
      return $this;
    }

    /**
     * @return ArrayOfSubmittedCustomerOrderSourcingDirective
     */
    public function getSourcingDirectives()
    {
      return $this->SourcingDirectives;
    }

    /**
     * @param ArrayOfSubmittedCustomerOrderSourcingDirective $SourcingDirectives
     * @return \Eurostop\Fulfilment\SubmittedCustomerOrder
     */
    public function setSourcingDirectives($SourcingDirectives)
    {
      $this->SourcingDirectives = $SourcingDirectives;
      return $this;
    }

}
