<?php

namespace Eurostop\Fulfilment;

class GetCustomerOrdersByIdentifier
{

    /**
     * @var string $fromCustomerOrderIdentifier
     */
    protected $fromCustomerOrderIdentifier = null;

    /**
     * @var string $toCustomerOrderIdentifier
     */
    protected $toCustomerOrderIdentifier = null;

    /**
     * @var CustomerOrderIdentifierType $customerOrderIdentifierType
     */
    protected $customerOrderIdentifierType = null;

    /**
     * @var int $maxCustomerOrders
     */
    protected $maxCustomerOrders = null;

    /**
     * @param string $fromCustomerOrderIdentifier
     * @param string $toCustomerOrderIdentifier
     * @param CustomerOrderIdentifierType $customerOrderIdentifierType
     * @param int $maxCustomerOrders
     */
    public function __construct($fromCustomerOrderIdentifier, $toCustomerOrderIdentifier, $customerOrderIdentifierType, $maxCustomerOrders)
    {
      $this->fromCustomerOrderIdentifier = $fromCustomerOrderIdentifier;
      $this->toCustomerOrderIdentifier = $toCustomerOrderIdentifier;
      $this->customerOrderIdentifierType = $customerOrderIdentifierType;
      $this->maxCustomerOrders = $maxCustomerOrders;
    }

    /**
     * @return string
     */
    public function getFromCustomerOrderIdentifier()
    {
      return $this->fromCustomerOrderIdentifier;
    }

    /**
     * @param string $fromCustomerOrderIdentifier
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByIdentifier
     */
    public function setFromCustomerOrderIdentifier($fromCustomerOrderIdentifier)
    {
      $this->fromCustomerOrderIdentifier = $fromCustomerOrderIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getToCustomerOrderIdentifier()
    {
      return $this->toCustomerOrderIdentifier;
    }

    /**
     * @param string $toCustomerOrderIdentifier
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByIdentifier
     */
    public function setToCustomerOrderIdentifier($toCustomerOrderIdentifier)
    {
      $this->toCustomerOrderIdentifier = $toCustomerOrderIdentifier;
      return $this;
    }

    /**
     * @return CustomerOrderIdentifierType
     */
    public function getCustomerOrderIdentifierType()
    {
      return $this->customerOrderIdentifierType;
    }

    /**
     * @param CustomerOrderIdentifierType $customerOrderIdentifierType
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByIdentifier
     */
    public function setCustomerOrderIdentifierType($customerOrderIdentifierType)
    {
      $this->customerOrderIdentifierType = $customerOrderIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxCustomerOrders()
    {
      return $this->maxCustomerOrders;
    }

    /**
     * @param int $maxCustomerOrders
     * @return \Eurostop\Fulfilment\GetCustomerOrdersByIdentifier
     */
    public function setMaxCustomerOrders($maxCustomerOrders)
    {
      $this->maxCustomerOrders = $maxCustomerOrders;
      return $this;
    }

}
