<?php

namespace Eurostop\Fulfilment;

class DataSubmissionResult
{

    /**
     * @var string $ErrorSource
     */
    protected $ErrorSource = null;

    /**
     * @var string $Message
     */
    protected $Message = null;

    /**
     * @var SubmissionStatus $Status
     */
    protected $Status = null;

    /**
     * @var string $SubmissionToken
     */
    protected $SubmissionToken = null;

    /**
     * @var ArrayOfValidationError $ValidationErrors
     */
    protected $ValidationErrors = null;

    /**
     * @param SubmissionStatus $Status
     */
    public function __construct($Status)
    {
      $this->Status = $Status;
    }

    /**
     * @return string
     */
    public function getErrorSource()
    {
      return $this->ErrorSource;
    }

    /**
     * @param string $ErrorSource
     * @return \Eurostop\Fulfilment\DataSubmissionResult
     */
    public function setErrorSource($ErrorSource)
    {
      $this->ErrorSource = $ErrorSource;
      return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
      return $this->Message;
    }

    /**
     * @param string $Message
     * @return \Eurostop\Fulfilment\DataSubmissionResult
     */
    public function setMessage($Message)
    {
      $this->Message = $Message;
      return $this;
    }

    /**
     * @return SubmissionStatus
     */
    public function getStatus()
    {
      return $this->Status;
    }

    /**
     * @param SubmissionStatus $Status
     * @return \Eurostop\Fulfilment\DataSubmissionResult
     */
    public function setStatus($Status)
    {
      $this->Status = $Status;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionToken()
    {
      return $this->SubmissionToken;
    }

    /**
     * @param string $SubmissionToken
     * @return \Eurostop\Fulfilment\DataSubmissionResult
     */
    public function setSubmissionToken($SubmissionToken)
    {
      $this->SubmissionToken = $SubmissionToken;
      return $this;
    }

    /**
     * @return ArrayOfValidationError
     */
    public function getValidationErrors()
    {
      return $this->ValidationErrors;
    }

    /**
     * @param ArrayOfValidationError $ValidationErrors
     * @return \Eurostop\Fulfilment\DataSubmissionResult
     */
    public function setValidationErrors($ValidationErrors)
    {
      $this->ValidationErrors = $ValidationErrors;
      return $this;
    }

}
