<?php

namespace Eurostop\Fulfilment;

class CustomerOrderFulfilmentPlan extends RetrievedDataItemOfCustomerOrderFulfilmentPlanDtoHay9ORuz
{

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var ArrayOfCustomerOrderFulfilmentPlanDetail $Details
     */
    protected $Details = null;

    /**
     * @var boolean $IsManuallyGenerated
     */
    protected $IsManuallyGenerated = null;

    /**
     * @var \DateTime $ModifiedDate
     */
    protected $ModifiedDate = null;

    /**
     * @var int $PlanNumber
     */
    protected $PlanNumber = null;

    /**
     * @var CustomerOrderFulfilmentPlanStatus $PlanStatus
     */
    protected $PlanStatus = null;

    /**
     * @param \DateTime $CreatedDate
     * @param boolean $IsManuallyGenerated
     * @param \DateTime $ModifiedDate
     * @param int $PlanNumber
     * @param CustomerOrderFulfilmentPlanStatus $PlanStatus
     */
    public function __construct(\DateTime $CreatedDate, $IsManuallyGenerated, \DateTime $ModifiedDate, $PlanNumber, $PlanStatus)
    {
      parent::__construct();
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      $this->IsManuallyGenerated = $IsManuallyGenerated;
      $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
      $this->PlanNumber = $PlanNumber;
      $this->PlanStatus = $PlanStatus;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setCreatedDate(\DateTime $CreatedDate)
    {
      $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return ArrayOfCustomerOrderFulfilmentPlanDetail
     */
    public function getDetails()
    {
      return $this->Details;
    }

    /**
     * @param ArrayOfCustomerOrderFulfilmentPlanDetail $Details
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setDetails($Details)
    {
      $this->Details = $Details;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsManuallyGenerated()
    {
      return $this->IsManuallyGenerated;
    }

    /**
     * @param boolean $IsManuallyGenerated
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setIsManuallyGenerated($IsManuallyGenerated)
    {
      $this->IsManuallyGenerated = $IsManuallyGenerated;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedDate()
    {
      if ($this->ModifiedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ModifiedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ModifiedDate
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setModifiedDate(\DateTime $ModifiedDate)
    {
      $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return int
     */
    public function getPlanNumber()
    {
      return $this->PlanNumber;
    }

    /**
     * @param int $PlanNumber
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setPlanNumber($PlanNumber)
    {
      $this->PlanNumber = $PlanNumber;
      return $this;
    }

    /**
     * @return CustomerOrderFulfilmentPlanStatus
     */
    public function getPlanStatus()
    {
      return $this->PlanStatus;
    }

    /**
     * @param CustomerOrderFulfilmentPlanStatus $PlanStatus
     * @return \Eurostop\Fulfilment\CustomerOrderFulfilmentPlan
     */
    public function setPlanStatus($PlanStatus)
    {
      $this->PlanStatus = $PlanStatus;
      return $this;
    }

}
