<?php

namespace Eurostop\Stocks;

class TransferHeader extends CodedRetrievedDataItemOfTransferHeaderDto6qbTdoQx
{

    /**
     * @var \DateTime $ConfirmedDate
     */
    protected $ConfirmedDate = null;

    /**
     * @var \DateTime $CreatedDate
     */
    protected $CreatedDate = null;

    /**
     * @var string $FromBranchIdentifier
     */
    protected $FromBranchIdentifier = null;

    /**
     * @var ArrayOfTransferDetail $Lines
     */
    protected $Lines = null;

    /**
     * @var string $ReasonIdentifier
     */
    protected $ReasonIdentifier = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @var string $ToBranchIdentifier
     */
    protected $ToBranchIdentifier = null;

    /**
     * @var int $TransferId
     */
    protected $TransferId = null;

    /**
     * @var TransferType $TransferType
     */
    protected $TransferType = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedDate()
    {
      if ($this->ConfirmedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ConfirmedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ConfirmedDate
     * @return \Eurostop\Stocks\TransferHeader
     */
    public function setConfirmedDate(\DateTime $ConfirmedDate = null)
    {
      if ($ConfirmedDate == null) {
       $this->ConfirmedDate = null;
      } else {
        $this->ConfirmedDate = $ConfirmedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedDate()
    {
      if ($this->CreatedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CreatedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CreatedDate
     * @return \Eurostop\Stocks\TransferHeader
     */
    public function setCreatedDate(\DateTime $CreatedDate = null)
    {
      if ($CreatedDate == null) {
       $this->CreatedDate = null;
      } else {
        $this->CreatedDate = $CreatedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return string
     */
    public function getFromBranchIdentifier()
    {
      return $this->FromBranchIdentifier;
    }

    /**
     * @param string $FromBranchIdentifier
     * @return \Eurostop\Stocks\TransferHeader
     */
    public function setFromBranchIdentifier($FromBranchIdentifier)
    {
      $this->FromBranchIdentifier = $FromBranchIdentifier;
      return $this;
    }

    /**
     * @return ArrayOfTransferDetail
     */
    public function getLines()
    {
      return $this->Lines;
    }

    /**
     * @param ArrayOfTransferDetail $Lines
     * @return \Eurostop\Stocks\TransferHeader
     */
    public function setLines($Lines)
    {
      $this->Lines = $Lines;
      return $this;
    }

    /**
     * @return string
     */
    public function getReasonIdentifier()
    {
      return $this->ReasonIdentifier;
    }

    /**
     * @param string $ReasonIdentifier
     * @return \Eurostop\Stocks\TransferHeader
     */
    public function setReasonIdentifier($ReasonIdentifier)
    {
      $this->ReasonIdentifier = $ReasonIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return \Eurostop\Stocks\TransferHeader
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

    /**
     * @return string
     */
    public function getToBranchIdentifier()
    {
      return $this->ToBranchIdentifier;
    }

    /**
     * @param string $ToBranchIdentifier
     * @return \Eurostop\Stocks\TransferHeader
     */
    public function setToBranchIdentifier($ToBranchIdentifier)
    {
      $this->ToBranchIdentifier = $ToBranchIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getTransferId()
    {
      return $this->TransferId;
    }

    /**
     * @param int $TransferId
     * @return \Eurostop\Stocks\TransferHeader
     */
    public function setTransferId($TransferId)
    {
      $this->TransferId = $TransferId;
      return $this;
    }

    /**
     * @return TransferType
     */
    public function getTransferType()
    {
      return $this->TransferType;
    }

    /**
     * @param TransferType $TransferType
     * @return \Eurostop\Stocks\TransferHeader
     */
    public function setTransferType($TransferType)
    {
      $this->TransferType = $TransferType;
      return $this;
    }

}
