<?php

namespace Eurostop\Stocks;

class SubmittedTransferLine extends SubmittedDataItemOfSubmittedTransferLineDto6qbTdoQx
{

    /**
     * @var \DateTime $AuthorisedDate
     */
    protected $AuthorisedDate = null;

    /**
     * @var BranchIdentifierType $BranchIdentifierType
     */
    protected $BranchIdentifierType = null;

    /**
     * @var string $FromBranchIdentifier
     */
    protected $FromBranchIdentifier = null;

    /**
     * @var int $Quantity
     */
    protected $Quantity = null;

    /**
     * @var string $Reference
     */
    protected $Reference = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    /**
     * @var string $ToBranchIdentifier
     */
    protected $ToBranchIdentifier = null;

    
    public function __construct()
    {
      parent::__construct();
    }

    /**
     * @return \DateTime
     */
    public function getAuthorisedDate()
    {
      if ($this->AuthorisedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->AuthorisedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $AuthorisedDate
     * @return \Eurostop\Stocks\SubmittedTransferLine
     */
    public function setAuthorisedDate(\DateTime $AuthorisedDate = null)
    {
      if ($AuthorisedDate == null) {
       $this->AuthorisedDate = null;
      } else {
        $this->AuthorisedDate = $AuthorisedDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->BranchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $BranchIdentifierType
     * @return \Eurostop\Stocks\SubmittedTransferLine
     */
    public function setBranchIdentifierType($BranchIdentifierType)
    {
      $this->BranchIdentifierType = $BranchIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getFromBranchIdentifier()
    {
      return $this->FromBranchIdentifier;
    }

    /**
     * @param string $FromBranchIdentifier
     * @return \Eurostop\Stocks\SubmittedTransferLine
     */
    public function setFromBranchIdentifier($FromBranchIdentifier)
    {
      $this->FromBranchIdentifier = $FromBranchIdentifier;
      return $this;
    }

    /**
     * @return int
     */
    public function getQuantity()
    {
      return $this->Quantity;
    }

    /**
     * @param int $Quantity
     * @return \Eurostop\Stocks\SubmittedTransferLine
     */
    public function setQuantity($Quantity)
    {
      $this->Quantity = $Quantity;
      return $this;
    }

    /**
     * @return string
     */
    public function getReference()
    {
      return $this->Reference;
    }

    /**
     * @param string $Reference
     * @return \Eurostop\Stocks\SubmittedTransferLine
     */
    public function setReference($Reference)
    {
      $this->Reference = $Reference;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\SubmittedTransferLine
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Stocks\SubmittedTransferLine
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getToBranchIdentifier()
    {
      return $this->ToBranchIdentifier;
    }

    /**
     * @param string $ToBranchIdentifier
     * @return \Eurostop\Stocks\SubmittedTransferLine
     */
    public function setToBranchIdentifier($ToBranchIdentifier)
    {
      $this->ToBranchIdentifier = $ToBranchIdentifier;
      return $this;
    }

}
