<?php

namespace Eurostop\Stocks;

class SubmittedStockPositionCustom extends SubmittedDataItemOfSubmittedStockPositionDto6qbTdoQxCustom
{

    /**
     * @var string $BranchIdentifier
     */
    protected $BranchIdentifier = null;

    /**
     * @var BranchIdentifierType $BranchIdentifierType
     */
    protected $BranchIdentifierType = null;

    /**
     * @var int $NewUnitsFree
     */
    protected $NewUnitsFree = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var SkuIdentifierType $SkuIdentifierType
     */
    protected $SkuIdentifierType = null;

    /**
     * @param BranchIdentifierType $BranchIdentifierType
     * @param int $NewUnitsFree
     * @param SkuIdentifierType $SkuIdentifierType
     */
    public function __construct($BranchIdentifierType, $NewUnitsFree, $SkuIdentifierType)
    {
      parent::__construct();
      $this->BranchIdentifierType = $BranchIdentifierType;
      $this->NewUnitsFree = $NewUnitsFree;
      $this->SkuIdentifierType = $SkuIdentifierType;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->BranchIdentifier;
    }

    /**
     * @param string $BranchIdentifier
     * @return \Eurostop\Stocks\SubmittedStockPosition
     */
    public function setBranchIdentifier($BranchIdentifier)
    {
      $this->BranchIdentifier = $BranchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->BranchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $BranchIdentifierType
     * @return \Eurostop\Stocks\SubmittedStockPosition
     */
    public function setBranchIdentifierType($BranchIdentifierType)
    {
      $this->BranchIdentifierType = $BranchIdentifierType;
      return $this;
    }

    /**
     * @return int
     */
    public function getNewUnitsFree()
    {
      return $this->NewUnitsFree;
    }

    /**
     * @param int $NewUnitsFree
     * @return \Eurostop\Stocks\SubmittedStockPosition
     */
    public function setNewUnitsFree($NewUnitsFree)
    {
      $this->NewUnitsFree = $NewUnitsFree;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\SubmittedStockPosition
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->SkuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $SkuIdentifierType
     * @return \Eurostop\Stocks\SubmittedStockPosition
     */
    public function setSkuIdentifierType($SkuIdentifierType)
    {
      $this->SkuIdentifierType = $SkuIdentifierType;
      return $this;
    }

}
