<?php

namespace Eurostop\Stocks;

class SubmitWriteOnOffsCustom
{

    /**
     * @var ArrayOfSubmittedWriteOnOffLine $writeOnOffs
     */
    protected $writeOnOffs = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedWriteOnOffLine $writeOnOffs
     * @param string $submissionReference
     */
    public function __construct($writeOnOffs, $submissionReference)
    {
      $this->writeOnOffs = $writeOnOffs;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedWriteOnOffLine
     */
    public function getWriteOnOffs()
    {
      return $this->writeOnOffs;
    }

    /**
     * @param ArrayOfSubmittedWriteOnOffLine $writeOnOffs
     * @return \Eurostop\Stocks\SubmitWriteOnOffs
     */
    public function setWriteOnOffs($writeOnOffs)
    {
      $this->writeOnOffs = $writeOnOffs;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitWriteOnOffs
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
