<?php

namespace Eurostop\Stocks;

class SubmitTransferAction
{

    /**
     * @var SubmittedTransferAction $transferAction
     */
    protected $transferAction = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedTransferAction $transferAction
     * @param string $submissionReference
     */
    public function __construct($transferAction, $submissionReference)
    {
      $this->transferAction = $transferAction;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedTransferAction
     */
    public function getTransferAction()
    {
      return $this->transferAction;
    }

    /**
     * @param SubmittedTransferAction $transferAction
     * @return \Eurostop\Stocks\SubmitTransferAction
     */
    public function setTransferAction($transferAction)
    {
      $this->transferAction = $transferAction;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitTransferAction
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
