<?php

namespace Eurostop\Stocks;

class SubmitReplenishmentTargets
{

    /**
     * @var ArrayOfSubmittedReplenishmentTarget $targets
     */
    protected $targets = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedReplenishmentTarget $targets
     * @param string $submissionReference
     */
    public function __construct($targets = null, $submissionReference = null)
    {
      $this->targets = $targets;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedReplenishmentTarget
     */
    public function getTargets()
    {
      return $this->targets;
    }

    /**
     * @param ArrayOfSubmittedReplenishmentTarget $targets
     * @return \Eurostop\Stocks\SubmitReplenishmentTargets
     */
    public function setTargets($targets)
    {
      $this->targets = $targets;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitReplenishmentTargets
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
