<?php

namespace Eurostop\Stocks;

class SubmitNewStockPositionsCustom
{

    /**
     * @var ArrayOfSubmittedStockPosition $stockPositions
     */
    protected $stockPositions = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param ArrayOfSubmittedStockPosition $stockPositions
     * @param string $submissionReference
     */
    public function __construct($stockPositions, $submissionReference)
    {
      $this->stockPositions = $stockPositions;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return ArrayOfSubmittedStockPosition
     */
    public function getStockPositions()
    {
      return $this->stockPositions;
    }

    /**
     * @param ArrayOfSubmittedStockPosition $stockPositions
     * @return \Eurostop\Stocks\SubmitNewStockPositions
     */
    public function setStockPositions($stockPositions)
    {
      $this->stockPositions = $stockPositions;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitNewStockPositions
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
