<?php

namespace Eurostop\Stocks;

class SubmitAllocationAction
{

    /**
     * @var SubmittedAllocationAction $allocationAction
     */
    protected $allocationAction = null;

    /**
     * @var string $submissionReference
     */
    protected $submissionReference = null;

    /**
     * @param SubmittedAllocationAction $allocationAction
     * @param string $submissionReference
     */
    public function __construct($allocationAction, $submissionReference)
    {
      $this->allocationAction = $allocationAction;
      $this->submissionReference = $submissionReference;
    }

    /**
     * @return SubmittedAllocationAction
     */
    public function getAllocationAction()
    {
      return $this->allocationAction;
    }

    /**
     * @param SubmittedAllocationAction $allocationAction
     * @return \Eurostop\Stocks\SubmitAllocationAction
     */
    public function setAllocationAction($allocationAction)
    {
      $this->allocationAction = $allocationAction;
      return $this;
    }

    /**
     * @return string
     */
    public function getSubmissionReference()
    {
      return $this->submissionReference;
    }

    /**
     * @param string $submissionReference
     * @return \Eurostop\Stocks\SubmitAllocationAction
     */
    public function setSubmissionReference($submissionReference)
    {
      $this->submissionReference = $submissionReference;
      return $this;
    }

}
