<?php

namespace Eurostop\Stocks;

class StockWebServiceInterfacePluginCustom extends \SoapClient
{

    /**
     * @var array $classmap The defined classes
     */
    private static $classmap = array (
      'AllocationHeader' => 'Eurostop\\Stocks\\AllocationHeader',
      'ArrayOfAllocationDetail' => 'Eurostop\\Stocks\\ArrayOfAllocationDetail',
      'AllocationDetail' => 'Eurostop\\Stocks\\AllocationDetail',
      'ArrayOfAllocationHeader' => 'Eurostop\\Stocks\\ArrayOfAllocationHeader',
      'SubmittedAllocationHeader' => 'Eurostop\\Stocks\\SubmittedAllocationHeader',
      'ArrayOfSubmittedAllocationItem' => 'Eurostop\\Stocks\\ArrayOfSubmittedAllocationItem',
      'SubmittedAllocationItem' => 'Eurostop\\Stocks\\SubmittedAllocationItem',
      'ArrayOfSubmittedAllocationHeader' => 'Eurostop\\Stocks\\ArrayOfSubmittedAllocationHeader',
      'SubmittedAllocationAction' => 'Eurostop\\Stocks\\SubmittedAllocationAction',
      'ArrayOfSubmittedAllocationAction' => 'Eurostop\\Stocks\\ArrayOfSubmittedAllocationAction',
      'AdviceNoteHeader' => 'Eurostop\\Stocks\\AdviceNoteHeader',
      'ArrayOfAdviceNoteDetail' => 'Eurostop\\Stocks\\ArrayOfAdviceNoteDetail',
      'AdviceNoteDetail' => 'Eurostop\\Stocks\\AdviceNoteDetail',
      'ArrayOfAdviceNoteHeader' => 'Eurostop\\Stocks\\ArrayOfAdviceNoteHeader',
      'Stock' => 'Eurostop\\Stocks\\StockCustom',
      'ArrayOfStock' => 'Eurostop\\Stocks\\ArrayOfStockCustom',
      'ArrayOfSubmittedStockPosition' => 'Eurostop\\Stocks\\ArrayOfSubmittedStockPositionCustom',
      'SubmittedStockPosition' => 'Eurostop\\Stocks\\SubmittedStockPositionCustom',
      'StockForSku' => 'Eurostop\\Stocks\\StockForSkuCustom',
      'ArrayOfStockForSku' => 'Eurostop\\Stocks\\ArrayOfStockForSkuCustom',
      'ArrayOfSubmittedDeliveryLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedDeliveryLineCustom',
      'SubmittedDeliveryLine' => 'Eurostop\\Stocks\\SubmittedDeliveryLineCustom',
      'DeliveryHeader' => 'Eurostop\\Stocks\\DeliveryHeaderCustom',
      'ArrayOfDeliveryDetail' => 'Eurostop\\Stocks\\ArrayOfDeliveryDetailCustom',
      'DeliveryDetail' => 'Eurostop\\Stocks\\DeliveryDetailCustom',
      'ArrayOfDeliveryHeader' => 'Eurostop\\Stocks\\ArrayOfDeliveryHeaderCustom',
      'TransferHeader' => 'Eurostop\\Stocks\\TransferHeaderCustom',
      'ArrayOfTransferDetail' => 'Eurostop\\Stocks\\ArrayOfTransferDetailCustom',
      'TransferDetail' => 'Eurostop\\Stocks\\TransferDetailCustom',
      'ArrayOfTransferHeader' => 'Eurostop\\Stocks\\ArrayOfTransferHeaderCustom',
      'ArrayOfSubmittedTransferLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedTransferLineCustom',
      'SubmittedTransferLine' => 'Eurostop\\Stocks\\SubmittedTransferLineCustom',
      'SubmittedTransferHeader' => 'Eurostop\\Stocks\\SubmittedTransferHeader',
      'ArrayOfSubmittedTransferItem' => 'Eurostop\\Stocks\\ArrayOfSubmittedTransferItem',
      'SubmittedTransferItem' => 'Eurostop\\Stocks\\SubmittedTransferItem',
      'ArrayOfSubmittedTransferHeader' => 'Eurostop\\Stocks\\ArrayOfSubmittedTransferHeader',
      'SubmittedTransferAction' => 'Eurostop\\Stocks\\SubmittedTransferAction',
      'ArrayOfSubmittedTransferAction' => 'Eurostop\\Stocks\\ArrayOfSubmittedTransferAction',
      'PurchaseOrderHeader' => 'Eurostop\\Stocks\\PurchaseOrderHeaderCustom',
      'ArrayOfPurchaseOrderDetail' => 'Eurostop\\Stocks\\ArrayOfPurchaseOrderDetailCustom',
      'PurchaseOrderDetail' => 'Eurostop\\Stocks\\PurchaseOrderDetailCustom',
      'ArrayOfPurchaseOrderHeader' => 'Eurostop\\Stocks\\ArrayOfPurchaseOrderHeaderCustom',
      'ArrayOfSubmittedPurchaseOrderLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedPurchaseOrderLineCustom',
      'SubmittedPurchaseOrderLine' => 'Eurostop\\Stocks\\SubmittedPurchaseOrderLineCustom',
      'SubmittedPurchaseOrderAction' => 'Eurostop\\Stocks\\SubmittedPurchaseOrderAction',
      'ArrayOfSubmittedPurchaseOrderAction' => 'Eurostop\\Stocks\\ArrayOfSubmittedPurchaseOrderAction',
      'WriteOnOffHeader' => 'Eurostop\\Stocks\\WriteOnOffHeaderCustom',
      'ArrayOfWriteOnOffDetail' => 'Eurostop\\Stocks\\ArrayOfWriteOnOffDetailCustom',
      'WriteOnOffDetail' => 'Eurostop\\Stocks\\WriteOnOffDetailCustom',
      'ArrayOfWriteOnOffHeader' => 'Eurostop\\Stocks\\ArrayOfWriteOnOffHeaderCustom',
      'ArrayOfSubmittedWriteOnOffLine' => 'Eurostop\\Stocks\\ArrayOfSubmittedWriteOnOffLineCustom',
      'SubmittedWriteOnOffLine' => 'Eurostop\\Stocks\\SubmittedWriteOnOffLineCustom',
      'ArrayOfSubmittedReplenishmentTarget' => 'Eurostop\\Stocks\\ArrayOfSubmittedReplenishmentTargetCustom',
      'SubmittedReplenishmentTarget' => 'Eurostop\\Stocks\\SubmittedReplenishmentTargetCustom',
      'ArrayOfSubmittedSkuReplenishmentCeiling' => 'Eurostop\\Stocks\\ArrayOfSubmittedSkuReplenishmentCeilingCustom',
      'SubmittedSkuReplenishmentCeiling' => 'Eurostop\\Stocks\\SubmittedSkuReplenishmentCeilingCustom',
      'DataRetrievalResultOfAllocationHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfAllocationHeaderF65MdnO4',
      'CodedRetrievedDataItemOfAllocationHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfAllocationHeaderDto6qbTdoQx',
      'RetrievedDataItemOfAllocationHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfAllocationHeaderDto6qbTdoQx',
      'RetrievedDataItemOfAllocationDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfAllocationDetailDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedAllocationHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedAllocationHeaderDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedAllocationItemDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedAllocationItemDto6qbTdoQx',
      'DataSubmissionResult' => 'Eurostop\\Stocks\\DataSubmissionResultCustom',
      'ArrayOfValidationError' => 'Eurostop\\Stocks\\ArrayOfValidationErrorCustom',
      'ValidationError' => 'Eurostop\\Stocks\\ValidationErrorCustom',
      'SubmittedDataActionOfSubmittedAllocationActionDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataActionOfSubmittedAllocationActionDto6qbTdoQx',
      'DataRetrievalResultOfAdviceNoteHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfAdviceNoteHeaderF65MdnO4',
      'CodedRetrievedDataItemOfAdviceNoteHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfAdviceNoteHeaderDto6qbTdoQx',
      'RetrievedDataItemOfAdviceNoteHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfAdviceNoteHeaderDto6qbTdoQx',
      'RetrievedDataItemOfAdviceNoteDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfAdviceNoteDetailDto6qbTdoQx',
      'DataRetrievalResultOfStockF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfStockF65MdnO4Custom',
      'RetrievedDataItemOfStockPositionDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfStockPositionDto6qbTdoQxCustom',
      'SubmittedDataItemOfSubmittedStockPositionDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedStockPositionDto6qbTdoQxCustom',
      'DataRetrievalResultOfStockForSkuF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfStockForSkuF65MdnO4Custom',
      'RetrievedDataItemOfStockPositionForSkuDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfStockPositionForSkuDto6qbTdoQxCustom',
      'SubmittedDataItemOfSubmittedDeliveryLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedDeliveryLineDto6qbTdoQxCustom',
      'DataRetrievalResultOfDeliveryHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfDeliveryHeaderF65MdnO4Custom',
      'CodedRetrievedDataItemOfDeliveryHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfDeliveryHeaderDto6qbTdoQxCustom',
      'RetrievedDataItemOfDeliveryHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfDeliveryHeaderDto6qbTdoQxCustom',
      'RetrievedDataItemOfDeliveryDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfDeliveryDetailDto6qbTdoQxCustom',
      'DataRetrievalResultOfTransferHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfTransferHeaderF65MdnO4Custom',
      'CodedRetrievedDataItemOfTransferHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfTransferHeaderDto6qbTdoQxCustom',
      'RetrievedDataItemOfTransferHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfTransferHeaderDto6qbTdoQxCustom',
      'RetrievedDataItemOfTransferDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfTransferDetailDto6qbTdoQxCustom',
      'SubmittedDataItemOfSubmittedTransferLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedTransferLineDto6qbTdoQxCustom',
      'SubmittedDataItemOfSubmittedTransferHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedTransferHeaderDto6qbTdoQx',
      'SubmittedDataItemOfSubmittedTransferItemDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedTransferItemDto6qbTdoQx',
      'SubmittedDataActionOfSubmittedTransferActionDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataActionOfSubmittedTransferActionDto6qbTdoQx',
      'DataRetrievalResultOfPurchaseOrderHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfPurchaseOrderHeaderF65MdnO4Custom',
      'CodedRetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQxCustom',
      'RetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfPurchaseOrderHeaderDto6qbTdoQxCustom',
      'RetrievedDataItemOfPurchaseOrderDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfPurchaseOrderDetailDto6qbTdoQxCustom',
      'SubmittedDataItemOfSubmittedPurchaseOrderLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedPurchaseOrderLineDto6qbTdoQxCustom',
      'SubmittedDataActionOfSubmittedPurchaseOrderActionDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataActionOfSubmittedPurchaseOrderActionDto6qbTdoQx',
      'DataRetrievalResultOfWriteOnOffHeaderF65MdnO4' => 'Eurostop\\Stocks\\DataRetrievalResultOfWriteOnOffHeaderF65MdnO4Custom',
      'CodedRetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\CodedRetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQxCustom',
      'RetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfWriteOnOffHeaderDto6qbTdoQxCustom',
      'RetrievedDataItemOfWriteOnOffDetailDto6qbTdoQx' => 'Eurostop\\Stocks\\RetrievedDataItemOfWriteOnOffDetailDto6qbTdoQxCustom',
      'SubmittedDataItemOfSubmittedWriteOnOffLineDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedWriteOnOffLineDto6qbTdoQxCustom',
      'SubmittedDataItemOfSubmittedReplenishmentTargetDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedReplenishmentTargetDto6qbTdoQxCustom',
      'SubmittedDataItemOfSubmittedSkuReplenishmentCeilingDto6qbTdoQx' => 'Eurostop\\Stocks\\SubmittedDataItemOfSubmittedSkuReplenishmentCeilingDto6qbTdoQxCustom',
      'ArrayOfDataProcessingResult' => 'Eurostop\\Stocks\\ArrayOfDataProcessingResultCustom',
      'DataProcessingResult' => 'Eurostop\\Stocks\\DataProcessingResultCustom',
      'ArrayOfDataProcessingStatus' => 'Eurostop\\Stocks\\ArrayOfDataProcessingStatusCustom',
      'DataProcessingStatus' => 'Eurostop\\Stocks\\DataProcessingStatusCustom',
      'ArrayOfstring' => 'Eurostop\\Stocks\\ArrayOfstringCustom',
      'GetAllocationByIdentifier' => 'Eurostop\\Stocks\\GetAllocationByIdentifier',
      'GetAllocationByIdentifierResponse' => 'Eurostop\\Stocks\\GetAllocationByIdentifierResponse',
      'GetAllocationByIdentifierAndBranch' => 'Eurostop\\Stocks\\GetAllocationByIdentifierAndBranch',
      'GetAllocationByIdentifierAndBranchResponse' => 'Eurostop\\Stocks\\GetAllocationByIdentifierAndBranchResponse',
      'GetAllocationsByWarehouseAndDate' => 'Eurostop\\Stocks\\GetAllocationsByWarehouseAndDate',
      'GetAllocationsByWarehouseAndDateResponse' => 'Eurostop\\Stocks\\GetAllocationsByWarehouseAndDateResponse',
      'GetAllocationsByPurchaseOrder' => 'Eurostop\\Stocks\\GetAllocationsByPurchaseOrder',
      'GetAllocationsByPurchaseOrderResponse' => 'Eurostop\\Stocks\\GetAllocationsByPurchaseOrderResponse',
      'GetAllocationsByDelivery' => 'Eurostop\\Stocks\\GetAllocationsByDelivery',
      'GetAllocationsByDeliveryResponse' => 'Eurostop\\Stocks\\GetAllocationsByDeliveryResponse',
      'SubmitAllocation' => 'Eurostop\\Stocks\\SubmitAllocation',
      'SubmitAllocationResponse' => 'Eurostop\\Stocks\\SubmitAllocationResponse',
      'SubmitAllocations' => 'Eurostop\\Stocks\\SubmitAllocations',
      'SubmitAllocationsResponse' => 'Eurostop\\Stocks\\SubmitAllocationsResponse',
      'SubmitAllocationAction' => 'Eurostop\\Stocks\\SubmitAllocationAction',
      'SubmitAllocationActionResponse' => 'Eurostop\\Stocks\\SubmitAllocationActionResponse',
      'SubmitAllocationActions' => 'Eurostop\\Stocks\\SubmitAllocationActions',
      'SubmitAllocationActionsResponse' => 'Eurostop\\Stocks\\SubmitAllocationActionsResponse',
      'GetAdviceNoteByIdentifier' => 'Eurostop\\Stocks\\GetAdviceNoteByIdentifier',
      'GetAdviceNoteByIdentifierResponse' => 'Eurostop\\Stocks\\GetAdviceNoteByIdentifierResponse',
      'GetAdviceNotesByCreatedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByCreatedDate',
      'GetAdviceNotesByCreatedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByCreatedDateResponse',
      'GetAdviceNotesByModifiedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByModifiedDate',
      'GetAdviceNotesByModifiedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByModifiedDateResponse',
      'GetAdviceNotesByDespatchedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByDespatchedDate',
      'GetAdviceNotesByDespatchedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByDespatchedDateResponse',
      'GetAdviceNotesByBookedInDate' => 'Eurostop\\Stocks\\GetAdviceNotesByBookedInDate',
      'GetAdviceNotesByBookedInDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByBookedInDateResponse',
      'GetAdviceNotesByBranchCreatedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchCreatedDate',
      'GetAdviceNotesByBranchCreatedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchCreatedDateResponse',
      'GetAdviceNotesByBranchModifiedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchModifiedDate',
      'GetAdviceNotesByBranchModifiedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchModifiedDateResponse',
      'GetAdviceNotesByBranchDespatchedDate' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchDespatchedDate',
      'GetAdviceNotesByBranchDespatchedDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchDespatchedDateResponse',
      'GetAdviceNotesByBranchBookedInDate' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchBookedInDate',
      'GetAdviceNotesByBranchBookedInDateResponse' => 'Eurostop\\Stocks\\GetAdviceNotesByBranchBookedInDateResponse',
      'GetCurrentStockPositionByBranch' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchCustom',
      'GetCurrentStockPositionByBranchResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchResponseCustom',
      'GetCurrentStockPositionByBranchAndSku' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSkuCustom',
      'GetCurrentStockPositionByBranchAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSkuResponseCustom',
      'GetCurrentStockPositionByBranchAndHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndHierarchyNodeCustom',
      'GetCurrentStockPositionByBranchAndHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndHierarchyNodeResponseCustom',
      'GetCurrentStockPositionByBranchAndProduct' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProductCustom',
      'GetCurrentStockPositionByBranchAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProductResponseCustom',
      'GetCurrentStockPositionByBranchList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchList',
      'GetCurrentStockPositionByBranchListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListResponse',
      'GetCurrentStockPositionByBranchListAndSku' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndSku',
      'GetCurrentStockPositionByBranchListAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndSkuResponse',
      'GetCurrentStockPositionByBranchListAndHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndHierarchyNode',
      'GetCurrentStockPositionByBranchListAndHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndHierarchyNodeResponse',
      'GetCurrentStockPositionByBranchListAndProduct' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndProduct',
      'GetCurrentStockPositionByBranchListAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndProductResponse',
      'GetCurrentStockPositionBySku' => 'Eurostop\\Stocks\\GetCurrentStockPositionBySkuCustom',
      'GetCurrentStockPositionBySkuResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionBySkuResponseCustom',
      'GetCurrentStockPositionByHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentStockPositionByHierarchyNodeCustom',
      'GetCurrentStockPositionByHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByHierarchyNodeResponseCustom',
      'GetCurrentStockPositionByProduct' => 'Eurostop\\Stocks\\GetCurrentStockPositionByProductCustom',
      'GetCurrentStockPositionByProductResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByProductResponseCustom',
      'GetCurrentStockPositionByBranchGroup' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupCustom',
      'GetCurrentStockPositionByBranchGroupResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupResponseCustom',
      'GetCurrentStockPositionByBranchGroupAndProduct' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductCustom',
      'GetCurrentStockPositionByBranchGroupAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductResponseCustom',
      'GetCurrentStockPositionByBranchGroupAndSku' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSkuCustom',
      'GetCurrentStockPositionByBranchGroupAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSkuResponseCustom',
      'GetCurrentStockPositionByBranchGroupAndProductList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductListCustom',
      'GetCurrentStockPositionByBranchGroupAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndProductListResponseCustom',
      'GetCurrentStockPositionByBranchAndProductList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProductListCustom',
      'GetCurrentStockPositionByBranchAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndProductListResponseCustom',
      'GetCurrentStockPositionByBranchListAndProductList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndProductList',
      'GetCurrentStockPositionByBranchListAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndProductListResponse',
      'GetCurrentStockPositionByBranchGroupAndSkuList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSkuListCustom',
      'GetCurrentStockPositionByBranchGroupAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchGroupAndSkuListResponseCustom',
      'GetCurrentStockPositionByBranchAndSkuList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSkuListCustom',
      'GetCurrentStockPositionByBranchAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchAndSkuListResponseCustom',
      'GetCurrentStockPositionByBranchListAndSkuList' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndSkuList',
      'GetCurrentStockPositionByBranchListAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentStockPositionByBranchListAndSkuListResponse',
      'SubmitNewStockPositions' => 'Eurostop\\Stocks\\SubmitNewStockPositionsCustom',
      'SubmitNewStockPositionsResponse' => 'Eurostop\\Stocks\\SubmitNewStockPositionsResponseCustom',
      'GetCurrentSkuStockByBranch' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchCustom',
      'GetCurrentSkuStockByBranchResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchResponseCustom',
      'GetCurrentSkuStockByBranchAndSku' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSkuCustom',
      'GetCurrentSkuStockByBranchAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSkuResponseCustom',
      'GetCurrentSkuStockByBranchAndHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndHierarchyNodeCustom',
      'GetCurrentSkuStockByBranchAndHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndHierarchyNodeResponseCustom',
      'GetCurrentSkuStockByBranchAndProduct' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProductCustom',
      'GetCurrentSkuStockByBranchAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProductResponseCustom',
      'GetCurrentSkuStockByBranchList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchList',
      'GetCurrentSkuStockByBranchListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListResponse',
      'GetCurrentSkuStockByBranchListAndSku' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndSku',
      'GetCurrentSkuStockByBranchListAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndSkuResponse',
      'GetCurrentSkuStockByBranchListAndHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndHierarchyNode',
      'GetCurrentSkuStockByBranchListAndHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndHierarchyNodeResponse',
      'GetCurrentSkuStockByBranchListAndProduct' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndProduct',
      'GetCurrentSkuStockByBranchListAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndProductResponse',
      'GetCurrentSkuStockBySku' => 'Eurostop\\Stocks\\GetCurrentSkuStockBySkuCustom',
      'GetCurrentSkuStockBySkuResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockBySkuResponseCustom',
      'GetCurrentSkuStockByHierarchyNode' => 'Eurostop\\Stocks\\GetCurrentSkuStockByHierarchyNodeCustom',
      'GetCurrentSkuStockByHierarchyNodeResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByHierarchyNodeResponseCustom',
      'GetCurrentSkuStockByProduct' => 'Eurostop\\Stocks\\GetCurrentSkuStockByProductCustom',
      'GetCurrentSkuStockByProductResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByProductResponseCustom',
      'GetCurrentSkuStockByBranchGroup' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupCustom',
      'GetCurrentSkuStockByBranchGroupResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupResponseCustom',
      'GetCurrentSkuStockByBranchGroupAndProduct' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductCustom',
      'GetCurrentSkuStockByBranchGroupAndProductResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductResponseCustom',
      'GetCurrentSkuStockByBranchGroupAndSku' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSkuCustom',
      'GetCurrentSkuStockByBranchGroupAndSkuResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSkuResponseCustom',
      'GetCurrentSkuStockByBranchGroupAndProductList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductListCustom',
      'GetCurrentSkuStockByBranchGroupAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndProductListResponseCustom',
      'GetCurrentSkuStockByBranchAndProductList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProductListCustom',
      'GetCurrentSkuStockByBranchAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndProductListResponseCustom',
      'GetCurrentSkuStockByBranchListAndProductList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndProductList',
      'GetCurrentSkuStockByBranchListAndProductListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndProductListResponse',
      'GetCurrentSkuStockByBranchGroupAndSkuList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSkuListCustom',
      'GetCurrentSkuStockByBranchGroupAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchGroupAndSkuListResponseCustom',
      'GetCurrentSkuStockByBranchAndSkuList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSkuListCustom',
      'GetCurrentSkuStockByBranchAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchAndSkuListResponseCustom',
      'GetCurrentSkuStockByBranchListAndSkuList' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndSkuList',
      'GetCurrentSkuStockByBranchListAndSkuListResponse' => 'Eurostop\\Stocks\\GetCurrentSkuStockByBranchListAndSkuListResponse',
      'SubmitDeliveries' => 'Eurostop\\Stocks\\SubmitDeliveriesCustom',
      'SubmitDeliveriesResponse' => 'Eurostop\\Stocks\\SubmitDeliveriesResponseCustom',
      'GetDeliveriesByWarehouse' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouseCustom',
      'GetDeliveriesByWarehouseResponse' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouseResponseCustom',
      'GetDeliveriesByWarehouseAndDate' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouseAndDateCustom',
      'GetDeliveriesByWarehouseAndDateResponse' => 'Eurostop\\Stocks\\GetDeliveriesByWarehouseAndDateResponseCustom',
      'GetDeliveriesByDates' => 'Eurostop\\Stocks\\GetDeliveriesByDatesCustom',
      'GetDeliveriesByDatesResponse' => 'Eurostop\\Stocks\\GetDeliveriesByDatesResponseCustom',
      'GetDeliveryByIdentifier' => 'Eurostop\\Stocks\\GetDeliveryByIdentifierCustom',
      'GetDeliveryByIdentifierResponse' => 'Eurostop\\Stocks\\GetDeliveryByIdentifierResponseCustom',
      'GetDeliveriesByPurchaseOrder' => 'Eurostop\\Stocks\\GetDeliveriesByPurchaseOrderCustom',
      'GetDeliveriesByPurchaseOrderResponse' => 'Eurostop\\Stocks\\GetDeliveriesByPurchaseOrderResponseCustom',
      'GetConsolidatedTransfersByBranchTransferDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchTransferDateCustom',
      'GetConsolidatedTransfersByBranchTransferDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchTransferDateResponseCustom',
      'GetConsolidatedTransfersByBranchConfirmedDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchConfirmedDate',
      'GetConsolidatedTransfersByBranchConfirmedDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchConfirmedDateResponse',
      'GetConsolidatedTransfersByBranchBookedInDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchBookedInDate',
      'GetConsolidatedTransfersByBranchBookedInDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBranchBookedInDateResponse',
      'GetConsolidatedTransfersByTransferDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByTransferDateCustom',
      'GetConsolidatedTransfersByTransferDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByTransferDateResponseCustom',
      'GetConsolidatedTransfersByConfirmedDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByConfirmedDate',
      'GetConsolidatedTransfersByConfirmedDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByConfirmedDateResponse',
      'GetConsolidatedTransfersByBookedInDate' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBookedInDate',
      'GetConsolidatedTransfersByBookedInDateResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransfersByBookedInDateResponse',
      'GetConsolidatedTransferByIdentifier' => 'Eurostop\\Stocks\\GetConsolidatedTransferByIdentifierCustom',
      'GetConsolidatedTransferByIdentifierResponse' => 'Eurostop\\Stocks\\GetConsolidatedTransferByIdentifierResponseCustom',
      'GetInOutTransfersByBranchTransferDate' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchTransferDateCustom',
      'GetInOutTransfersByBranchTransferDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchTransferDateResponseCustom',
      'GetInOutTransfersByBranchConfirmedDate' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchConfirmedDate',
      'GetInOutTransfersByBranchConfirmedDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchConfirmedDateResponse',
      'GetInOutTransfersByBranchBookedInDate' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchBookedInDate',
      'GetInOutTransfersByBranchBookedInDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByBranchBookedInDateResponse',
      'GetInOutTransfersByTransferDate' => 'Eurostop\\Stocks\\GetInOutTransfersByTransferDateCustom',
      'GetInOutTransfersByTransferDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByTransferDateResponseCustom',
      'GetInOutTransfersByConfirmedDate' => 'Eurostop\\Stocks\\GetInOutTransfersByConfirmedDate',
      'GetInOutTransfersByConfirmedDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByConfirmedDateResponse',
      'GetInOutTransfersByBookedInDate' => 'Eurostop\\Stocks\\GetInOutTransfersByBookedInDate',
      'GetInOutTransfersByBookedInDateResponse' => 'Eurostop\\Stocks\\GetInOutTransfersByBookedInDateResponse',
      'GetInOutTransferByIdentifier' => 'Eurostop\\Stocks\\GetInOutTransferByIdentifierCustom',
      'GetInOutTransferByIdentifierResponse' => 'Eurostop\\Stocks\\GetInOutTransferByIdentifierResponseCustom',
      'SubmitTransfers' => 'Eurostop\\Stocks\\SubmitTransfersCustom',
      'SubmitTransfersResponse' => 'Eurostop\\Stocks\\SubmitTransfersResponseCustom',
      'SubmitTransferBatch' => 'Eurostop\\Stocks\\SubmitTransferBatch',
      'SubmitTransferBatchResponse' => 'Eurostop\\Stocks\\SubmitTransferBatchResponse',
      'SubmitTransferBatches' => 'Eurostop\\Stocks\\SubmitTransferBatches',
      'SubmitTransferBatchesResponse' => 'Eurostop\\Stocks\\SubmitTransferBatchesResponse',
      'SubmitTransferAction' => 'Eurostop\\Stocks\\SubmitTransferAction',
      'SubmitTransferActionResponse' => 'Eurostop\\Stocks\\SubmitTransferActionResponse',
      'SubmitTransferActions' => 'Eurostop\\Stocks\\SubmitTransferActions',
      'SubmitTransferActionsResponse' => 'Eurostop\\Stocks\\SubmitTransferActionsResponse',
      'GetPurchaseOrdersByIdentifier' => 'Eurostop\\Stocks\\GetPurchaseOrdersByIdentifierCustom',
      'GetPurchaseOrdersByIdentifierResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByIdentifierResponseCustom',
      'GetPurchaseOrdersByDate' => 'Eurostop\\Stocks\\GetPurchaseOrdersByDateCustom',
      'GetPurchaseOrdersByDateResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByDateResponseCustom',
      'GetPurchaseOrdersByWarehouse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseCustom',
      'GetPurchaseOrdersByWarehouseResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseResponseCustom',
      'GetPurchaseOrdersByWarehouseAndDate' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseAndDateCustom',
      'GetPurchaseOrdersByWarehouseAndDateResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseAndDateResponseCustom',
      'GetPurchaseOrdersByConfirmedDate' => 'Eurostop\\Stocks\\GetPurchaseOrdersByConfirmedDate',
      'GetPurchaseOrdersByConfirmedDateResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByConfirmedDateResponse',
      'GetPurchaseOrdersByWarehouseAndConfirmedDate' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseAndConfirmedDate',
      'GetPurchaseOrdersByWarehouseAndConfirmedDateResponse' => 'Eurostop\\Stocks\\GetPurchaseOrdersByWarehouseAndConfirmedDateResponse',
      'SubmitPurchaseOrders' => 'Eurostop\\Stocks\\SubmitPurchaseOrdersCustom',
      'SubmitPurchaseOrdersResponse' => 'Eurostop\\Stocks\\SubmitPurchaseOrdersResponseCustom',
      'SubmitPurchaseOrderAction' => 'Eurostop\\Stocks\\SubmitPurchaseOrderAction',
      'SubmitPurchaseOrderActionResponse' => 'Eurostop\\Stocks\\SubmitPurchaseOrderActionResponse',
      'SubmitPurchaseOrderActions' => 'Eurostop\\Stocks\\SubmitPurchaseOrderActions',
      'SubmitPurchaseOrderActionsResponse' => 'Eurostop\\Stocks\\SubmitPurchaseOrderActionsResponse',
      'GetWriteOnOffsByBranchDate' => 'Eurostop\\Stocks\\GetWriteOnOffsByBranchDateCustom',
      'GetWriteOnOffsByBranchDateResponse' => 'Eurostop\\Stocks\\GetWriteOnOffsByBranchDateResponseCustom',
      'GetWriteOnOffsByDate' => 'Eurostop\\Stocks\\GetWriteOnOffsByDateCustom',
      'GetWriteOnOffsByDateResponse' => 'Eurostop\\Stocks\\GetWriteOnOffsByDateResponseCustom',
      'GetWriteOnOffByIdentifier' => 'Eurostop\\Stocks\\GetWriteOnOffByIdentifierCustom',
      'GetWriteOnOffByIdentifierResponse' => 'Eurostop\\Stocks\\GetWriteOnOffByIdentifierResponseCustom',
      'SubmitWriteOnOffs' => 'Eurostop\\Stocks\\SubmitWriteOnOffsCustom',
      'SubmitWriteOnOffsResponse' => 'Eurostop\\Stocks\\SubmitWriteOnOffsResponseCustom',
      'SubmitReplenishmentTargets' => 'Eurostop\\Stocks\\SubmitReplenishmentTargetsCustom',
      'SubmitReplenishmentTargetsResponse' => 'Eurostop\\Stocks\\SubmitReplenishmentTargetsResponseCustom',
      'SubmitSkuReplenishmentCeilings' => 'Eurostop\\Stocks\\SubmitSkuReplenishmentCeilingsCustom',
      'SubmitSkuReplenishmentCeilingsResponse' => 'Eurostop\\Stocks\\SubmitSkuReplenishmentCeilingsResponseCustom',
      'FlagDataProcessingToRetryByReference' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByReferenceCustom',
      'FlagDataProcessingToRetryByReferenceResponse' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByReferenceResponseCustom',
      'FlagDataProcessingToRetryByToken' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByTokenCustom',
      'FlagDataProcessingToRetryByTokenResponse' => 'Eurostop\\Stocks\\FlagDataProcessingToRetryByTokenResponseCustom',
      'RunDataProcessingByReference' => 'Eurostop\\Stocks\\RunDataProcessingByReferenceCustom',
      'RunDataProcessingByReferenceResponse' => 'Eurostop\\Stocks\\RunDataProcessingByReferenceResponseCustom',
      'RunDataProcessingByToken' => 'Eurostop\\Stocks\\RunDataProcessingByTokenCustom',
      'RunDataProcessingByTokenResponse' => 'Eurostop\\Stocks\\RunDataProcessingByTokenResponseCustom',
    );

    /**
     * @param array $options A array of config values
     * @param string $wsdl The wsdl file to use
     */
    public function __construct(array $options = array(), $wsdl = null)
    {
      foreach (self::$classmap as $key => $value) {
        if (!isset($options['classmap'][$key])) {
          $options['classmap'][$key] = $value;
        }
      }
      $options = array_merge(array (
      'features' => 1,
    ), $options);
      if (!$wsdl) {
        $wsdl = 'https://database-test.eurostop.jdsportscanada.com:9120/e-interface/stocks?wsdl';
      }
      parent::__construct($wsdl, $options);
    }

    /**
     * @param GetAllocationByIdentifier $parameters
     * @return GetAllocationByIdentifierResponse
     */
    public function GetAllocationByIdentifier(GetAllocationByIdentifier $parameters)
    {
      return $this->__soapCall('GetAllocationByIdentifier', array($parameters));
    }

    /**
     * @param GetAllocationByIdentifierAndBranch $parameters
     * @return GetAllocationByIdentifierAndBranchResponse
     */
    public function GetAllocationByIdentifierAndBranch(GetAllocationByIdentifierAndBranch $parameters)
    {
      return $this->__soapCall('GetAllocationByIdentifierAndBranch', array($parameters));
    }

    /**
     * @param GetAllocationsByWarehouseAndDate $parameters
     * @return GetAllocationsByWarehouseAndDateResponse
     */
    public function GetAllocationsByWarehouseAndDate(GetAllocationsByWarehouseAndDate $parameters)
    {
      return $this->__soapCall('GetAllocationsByWarehouseAndDate', array($parameters));
    }

    /**
     * @param GetAllocationsByPurchaseOrder $parameters
     * @return GetAllocationsByPurchaseOrderResponse
     */
    public function GetAllocationsByPurchaseOrder(GetAllocationsByPurchaseOrder $parameters)
    {
      return $this->__soapCall('GetAllocationsByPurchaseOrder', array($parameters));
    }

    /**
     * @param GetAllocationsByDelivery $parameters
     * @return GetAllocationsByDeliveryResponse
     */
    public function GetAllocationsByDelivery(GetAllocationsByDelivery $parameters)
    {
      return $this->__soapCall('GetAllocationsByDelivery', array($parameters));
    }

    /**
     * @param SubmitAllocation $parameters
     * @return SubmitAllocationResponse
     */
    public function SubmitAllocation(SubmitAllocation $parameters)
    {
      return $this->__soapCall('SubmitAllocation', array($parameters));
    }

    /**
     * @param SubmitAllocations $parameters
     * @return SubmitAllocationsResponse
     */
    public function SubmitAllocations(SubmitAllocations $parameters)
    {
      return $this->__soapCall('SubmitAllocations', array($parameters));
    }

    /**
     * @param SubmitAllocationAction $parameters
     * @return SubmitAllocationActionResponse
     */
    public function SubmitAllocationAction(SubmitAllocationAction $parameters)
    {
      return $this->__soapCall('SubmitAllocationAction', array($parameters));
    }

    /**
     * @param SubmitAllocationActions $parameters
     * @return SubmitAllocationActionsResponse
     */
    public function SubmitAllocationActions(SubmitAllocationActions $parameters)
    {
      return $this->__soapCall('SubmitAllocationActions', array($parameters));
    }

    /**
     * @param GetAdviceNoteByIdentifier $parameters
     * @return GetAdviceNoteByIdentifierResponse
     */
    public function GetAdviceNoteByIdentifier(GetAdviceNoteByIdentifier $parameters)
    {
      return $this->__soapCall('GetAdviceNoteByIdentifier', array($parameters));
    }

    /**
     * @param GetAdviceNotesByCreatedDate $parameters
     * @return GetAdviceNotesByCreatedDateResponse
     */
    public function GetAdviceNotesByCreatedDate(GetAdviceNotesByCreatedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByCreatedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByModifiedDate $parameters
     * @return GetAdviceNotesByModifiedDateResponse
     */
    public function GetAdviceNotesByModifiedDate(GetAdviceNotesByModifiedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByModifiedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByDespatchedDate $parameters
     * @return GetAdviceNotesByDespatchedDateResponse
     */
    public function GetAdviceNotesByDespatchedDate(GetAdviceNotesByDespatchedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByDespatchedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByBookedInDate $parameters
     * @return GetAdviceNotesByBookedInDateResponse
     */
    public function GetAdviceNotesByBookedInDate(GetAdviceNotesByBookedInDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByBookedInDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByBranchCreatedDate $parameters
     * @return GetAdviceNotesByBranchCreatedDateResponse
     */
    public function GetAdviceNotesByBranchCreatedDate(GetAdviceNotesByBranchCreatedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByBranchCreatedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByBranchModifiedDate $parameters
     * @return GetAdviceNotesByBranchModifiedDateResponse
     */
    public function GetAdviceNotesByBranchModifiedDate(GetAdviceNotesByBranchModifiedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByBranchModifiedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByBranchDespatchedDate $parameters
     * @return GetAdviceNotesByBranchDespatchedDateResponse
     */
    public function GetAdviceNotesByBranchDespatchedDate(GetAdviceNotesByBranchDespatchedDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByBranchDespatchedDate', array($parameters));
    }

    /**
     * @param GetAdviceNotesByBranchBookedInDate $parameters
     * @return GetAdviceNotesByBranchBookedInDateResponse
     */
    public function GetAdviceNotesByBranchBookedInDate(GetAdviceNotesByBranchBookedInDate $parameters)
    {
      return $this->__soapCall('GetAdviceNotesByBranchBookedInDate', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchCustom $parameters
     * @return GetCurrentStockPositionByBranchResponse
     */
    public function GetCurrentStockPositionByBranch($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranch', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndSkuCustom $parameters
     * @return GetCurrentStockPositionByBranchAndSkuResponse
     */
    public function GetCurrentStockPositionByBranchAndSku($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndSku', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndHierarchyNodeCustom $parameters
     * @return GetCurrentStockPositionByBranchAndHierarchyNodeResponse
     */
    public function GetCurrentStockPositionByBranchAndHierarchyNode($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndProductCustom $parameters
     * @return GetCurrentStockPositionByBranchAndProductResponse
     */
    public function GetCurrentStockPositionByBranchAndProduct($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchList $parameters
     * @return GetCurrentStockPositionByBranchListResponse
     */
    public function GetCurrentStockPositionByBranchList(GetCurrentStockPositionByBranchList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchListAndSku $parameters
     * @return GetCurrentStockPositionByBranchListAndSkuResponse
     */
    public function GetCurrentStockPositionByBranchListAndSku(GetCurrentStockPositionByBranchListAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchListAndSku', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchListAndHierarchyNode $parameters
     * @return GetCurrentStockPositionByBranchListAndHierarchyNodeResponse
     */
    public function GetCurrentStockPositionByBranchListAndHierarchyNode(GetCurrentStockPositionByBranchListAndHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchListAndHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchListAndProduct $parameters
     * @return GetCurrentStockPositionByBranchListAndProductResponse
     */
    public function GetCurrentStockPositionByBranchListAndProduct(GetCurrentStockPositionByBranchListAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchListAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionBySkuCustom $parameters
     * @return GetCurrentStockPositionBySkuResponse
     */
    public function GetCurrentStockPositionBySku($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionBySku', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByHierarchyNodeCustom $parameters
     * @return GetCurrentStockPositionByHierarchyNodeResponse
     */
    public function GetCurrentStockPositionByHierarchyNode($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByProductCustom $parameters
     * @return GetCurrentStockPositionByProductResponse
     */
    public function GetCurrentStockPositionByProduct($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByProduct', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupCustom $parameters
     * @return GetCurrentStockPositionByBranchGroupResponse
     */
    public function GetCurrentStockPositionByBranchGroup($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroup', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndProductCustom $parameters
     * @return GetCurrentStockPositionByBranchGroupAndProductResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndProduct($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndSkuCustom $parameters
     * @return GetCurrentStockPositionByBranchGroupAndSkuResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndSku($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndSku', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndProductListCustom $parameters
     * @return GetCurrentStockPositionByBranchGroupAndProductListResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndProductList($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndProductListCustom $parameters
     * @return GetCurrentStockPositionByBranchAndProductListResponse
     */
    public function GetCurrentStockPositionByBranchAndProductList($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchListAndProductList $parameters
     * @return GetCurrentStockPositionByBranchListAndProductListResponse
     */
    public function GetCurrentStockPositionByBranchListAndProductList(GetCurrentStockPositionByBranchListAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchListAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchGroupAndSkuListCustom $parameters
     * @return GetCurrentStockPositionByBranchGroupAndSkuListResponse
     */
    public function GetCurrentStockPositionByBranchGroupAndSkuList($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchGroupAndSkuList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchAndSkuListCustom $parameters
     * @return GetCurrentStockPositionByBranchAndSkuListResponse
     */
    public function GetCurrentStockPositionByBranchAndSkuList($parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchAndSkuList', array($parameters));
    }

    /**
     * @param GetCurrentStockPositionByBranchListAndSkuList $parameters
     * @return GetCurrentStockPositionByBranchListAndSkuListResponse
     */
    public function GetCurrentStockPositionByBranchListAndSkuList(GetCurrentStockPositionByBranchListAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentStockPositionByBranchListAndSkuList', array($parameters));
    }

    /**
     * @param SubmitNewStockPositionsCustom $parameters
     * @return SubmitNewStockPositionsResponse
     */
    public function SubmitNewStockPositions($parameters)
    {
      return $this->__soapCall('SubmitNewStockPositions', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchCustom $parameters
     * @return GetCurrentSkuStockByBranchResponse
     */
    public function GetCurrentSkuStockByBranch($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranch', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndSkuCustom $parameters
     * @return GetCurrentSkuStockByBranchAndSkuResponse
     */
    public function GetCurrentSkuStockByBranchAndSku($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndSku', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndHierarchyNodeCustom $parameters
     * @return GetCurrentSkuStockByBranchAndHierarchyNodeResponse
     */
    public function GetCurrentSkuStockByBranchAndHierarchyNode($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndProductCustom $parameters
     * @return GetCurrentSkuStockByBranchAndProductResponse
     */
    public function GetCurrentSkuStockByBranchAndProduct($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchList $parameters
     * @return GetCurrentSkuStockByBranchListResponse
     */
    public function GetCurrentSkuStockByBranchList(GetCurrentSkuStockByBranchList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchListAndSku $parameters
     * @return GetCurrentSkuStockByBranchListAndSkuResponse
     */
    public function GetCurrentSkuStockByBranchListAndSku(GetCurrentSkuStockByBranchListAndSku $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchListAndSku', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchListAndHierarchyNode $parameters
     * @return GetCurrentSkuStockByBranchListAndHierarchyNodeResponse
     */
    public function GetCurrentSkuStockByBranchListAndHierarchyNode(GetCurrentSkuStockByBranchListAndHierarchyNode $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchListAndHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchListAndProduct $parameters
     * @return GetCurrentSkuStockByBranchListAndProductResponse
     */
    public function GetCurrentSkuStockByBranchListAndProduct(GetCurrentSkuStockByBranchListAndProduct $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchListAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockBySkuCustom $parameters
     * @return GetCurrentSkuStockBySkuResponse
     */
    public function GetCurrentSkuStockBySku($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockBySku', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByHierarchyNodeCustom $parameters
     * @return GetCurrentSkuStockByHierarchyNodeResponse
     */
    public function GetCurrentSkuStockByHierarchyNode($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByHierarchyNode', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByProductCustom $parameters
     * @return GetCurrentSkuStockByProductResponse
     */
    public function GetCurrentSkuStockByProduct($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByProduct', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupCustom $parameters
     * @return GetCurrentSkuStockByBranchGroupResponse
     */
    public function GetCurrentSkuStockByBranchGroup($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroup', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndProductCustom $parameters
     * @return GetCurrentSkuStockByBranchGroupAndProductResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndProduct($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndProduct', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndSkuCustom $parameters
     * @return GetCurrentSkuStockByBranchGroupAndSkuResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndSku($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndSku', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndProductListCustom $parameters
     * @return GetCurrentSkuStockByBranchGroupAndProductListResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndProductList($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndProductListCustom $parameters
     * @return GetCurrentSkuStockByBranchAndProductListResponse
     */
    public function GetCurrentSkuStockByBranchAndProductList($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchListAndProductList $parameters
     * @return GetCurrentSkuStockByBranchListAndProductListResponse
     */
    public function GetCurrentSkuStockByBranchListAndProductList(GetCurrentSkuStockByBranchListAndProductList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchListAndProductList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchGroupAndSkuListCustom $parameters
     * @return GetCurrentSkuStockByBranchGroupAndSkuListResponse
     */
    public function GetCurrentSkuStockByBranchGroupAndSkuList($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchGroupAndSkuList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchAndSkuListCustom $parameters
     * @return GetCurrentSkuStockByBranchAndSkuListResponse
     */
    public function GetCurrentSkuStockByBranchAndSkuList($parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchAndSkuList', array($parameters));
    }

    /**
     * @param GetCurrentSkuStockByBranchListAndSkuList $parameters
     * @return GetCurrentSkuStockByBranchListAndSkuListResponse
     */
    public function GetCurrentSkuStockByBranchListAndSkuList(GetCurrentSkuStockByBranchListAndSkuList $parameters)
    {
      return $this->__soapCall('GetCurrentSkuStockByBranchListAndSkuList', array($parameters));
    }

    /**
     * @param SubmitDeliveriesCustom $parameters
     * @return SubmitDeliveriesResponse
     */
    public function SubmitDeliveries($parameters)
    {
      return $this->__soapCall('SubmitDeliveries', array($parameters));
    }

    /**
     * @param GetDeliveriesByWarehouseCustom $parameters
     * @return GetDeliveriesByWarehouseResponse
     */
    public function GetDeliveriesByWarehouse($parameters)
    {
      return $this->__soapCall('GetDeliveriesByWarehouse', array($parameters));
    }

    /**
     * @param GetDeliveriesByWarehouseAndDateCustom $parameters
     * @return GetDeliveriesByWarehouseAndDateResponse
     */
    public function GetDeliveriesByWarehouseAndDate($parameters)
    {
      return $this->__soapCall('GetDeliveriesByWarehouseAndDate', array($parameters));
    }

    /**
     * @param GetDeliveriesByDatesCustom $parameters
     * @return GetDeliveriesByDatesResponse
     */
    public function GetDeliveriesByDates($parameters)
    {
      return $this->__soapCall('GetDeliveriesByDates', array($parameters));
    }

    /**
     * @param GetDeliveryByIdentifierCustom $parameters
     * @return GetDeliveryByIdentifierResponse
     */
    public function GetDeliveryByIdentifier($parameters)
    {
      return $this->__soapCall('GetDeliveryByIdentifier', array($parameters));
    }

    /**
     * @param GetDeliveriesByPurchaseOrderCustom $parameters
     * @return GetDeliveriesByPurchaseOrderResponse
     */
    public function GetDeliveriesByPurchaseOrder($parameters)
    {
      return $this->__soapCall('GetDeliveriesByPurchaseOrder', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByBranchTransferDateCustom $parameters
     * @return GetConsolidatedTransfersByBranchTransferDateResponse
     */
    public function GetConsolidatedTransfersByBranchTransferDate($parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByBranchTransferDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByBranchConfirmedDate $parameters
     * @return GetConsolidatedTransfersByBranchConfirmedDateResponse
     */
    public function GetConsolidatedTransfersByBranchConfirmedDate(GetConsolidatedTransfersByBranchConfirmedDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByBranchConfirmedDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByBranchBookedInDate $parameters
     * @return GetConsolidatedTransfersByBranchBookedInDateResponse
     */
    public function GetConsolidatedTransfersByBranchBookedInDate(GetConsolidatedTransfersByBranchBookedInDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByBranchBookedInDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByTransferDateCustom $parameters
     * @return GetConsolidatedTransfersByTransferDateResponse
     */
    public function GetConsolidatedTransfersByTransferDate($parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByTransferDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByConfirmedDate $parameters
     * @return GetConsolidatedTransfersByConfirmedDateResponse
     */
    public function GetConsolidatedTransfersByConfirmedDate(GetConsolidatedTransfersByConfirmedDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByConfirmedDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransfersByBookedInDate $parameters
     * @return GetConsolidatedTransfersByBookedInDateResponse
     */
    public function GetConsolidatedTransfersByBookedInDate(GetConsolidatedTransfersByBookedInDate $parameters)
    {
      return $this->__soapCall('GetConsolidatedTransfersByBookedInDate', array($parameters));
    }

    /**
     * @param GetConsolidatedTransferByIdentifierCustom $parameters
     * @return GetConsolidatedTransferByIdentifierResponse
     */
    public function GetConsolidatedTransferByIdentifier($parameters)
    {
      return $this->__soapCall('GetConsolidatedTransferByIdentifier', array($parameters));
    }

    /**
     * @param GetInOutTransfersByBranchTransferDateCustom $parameters
     * @return GetInOutTransfersByBranchTransferDateResponse
     */
    public function GetInOutTransfersByBranchTransferDate($parameters)
    {
      return $this->__soapCall('GetInOutTransfersByBranchTransferDate', array($parameters));
    }

    /**
     * @param GetInOutTransfersByBranchConfirmedDate $parameters
     * @return GetInOutTransfersByBranchConfirmedDateResponse
     */
    public function GetInOutTransfersByBranchConfirmedDate(GetInOutTransfersByBranchConfirmedDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByBranchConfirmedDate', array($parameters));
    }

    /**
     * @param GetInOutTransfersByBranchBookedInDate $parameters
     * @return GetInOutTransfersByBranchBookedInDateResponse
     */
    public function GetInOutTransfersByBranchBookedInDate(GetInOutTransfersByBranchBookedInDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByBranchBookedInDate', array($parameters));
    }

    /**
     * @param GetInOutTransfersByTransferDateCustom $parameters
     * @return GetInOutTransfersByTransferDateResponse
     */
    public function GetInOutTransfersByTransferDate($parameters)
    {
      return $this->__soapCall('GetInOutTransfersByTransferDate', array($parameters));
    }

    /**
     * @param GetInOutTransfersByConfirmedDate $parameters
     * @return GetInOutTransfersByConfirmedDateResponse
     */
    public function GetInOutTransfersByConfirmedDate(GetInOutTransfersByConfirmedDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByConfirmedDate', array($parameters));
    }

    /**
     * @param GetInOutTransfersByBookedInDate $parameters
     * @return GetInOutTransfersByBookedInDateResponse
     */
    public function GetInOutTransfersByBookedInDate(GetInOutTransfersByBookedInDate $parameters)
    {
      return $this->__soapCall('GetInOutTransfersByBookedInDate', array($parameters));
    }

    /**
     * @param GetInOutTransferByIdentifierCustom $parameters
     * @return GetInOutTransferByIdentifierResponse
     */
    public function GetInOutTransferByIdentifier($parameters)
    {
      return $this->__soapCall('GetInOutTransferByIdentifier', array($parameters));
    }

    /**
     * @param SubmitTransfersCustom $parameters
     * @return SubmitTransfersResponse
     */
    public function SubmitTransfers($parameters)
    {
      return $this->__soapCall('SubmitTransfers', array($parameters));
    }

    /**
     * @param SubmitTransferBatch $parameters
     * @return SubmitTransferBatchResponse
     */
    public function SubmitTransferBatch(SubmitTransferBatch $parameters)
    {
      return $this->__soapCall('SubmitTransferBatch', array($parameters));
    }

    /**
     * @param SubmitTransferBatches $parameters
     * @return SubmitTransferBatchesResponse
     */
    public function SubmitTransferBatches(SubmitTransferBatches $parameters)
    {
      return $this->__soapCall('SubmitTransferBatches', array($parameters));
    }

    /**
     * @param SubmitTransferAction $parameters
     * @return SubmitTransferActionResponse
     */
    public function SubmitTransferAction(SubmitTransferAction $parameters)
    {
      return $this->__soapCall('SubmitTransferAction', array($parameters));
    }

    /**
     * @param SubmitTransferActions $parameters
     * @return SubmitTransferActionsResponse
     */
    public function SubmitTransferActions(SubmitTransferActions $parameters)
    {
      return $this->__soapCall('SubmitTransferActions', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByIdentifierCustom $parameters
     * @return GetPurchaseOrdersByIdentifierResponse
     */
    public function GetPurchaseOrdersByIdentifier($parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByIdentifier', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByDateCustom $parameters
     * @return GetPurchaseOrdersByDateResponse
     */
    public function GetPurchaseOrdersByDate($parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByDate', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByWarehouseCustom $parameters
     * @return GetPurchaseOrdersByWarehouseResponse
     */
    public function GetPurchaseOrdersByWarehouse($parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByWarehouse', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByWarehouseAndDateCustom $parameters
     * @return GetPurchaseOrdersByWarehouseAndDateResponse
     */
    public function GetPurchaseOrdersByWarehouseAndDate($parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByWarehouseAndDate', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByConfirmedDate $parameters
     * @return GetPurchaseOrdersByConfirmedDateResponse
     */
    public function GetPurchaseOrdersByConfirmedDate(GetPurchaseOrdersByConfirmedDate $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByConfirmedDate', array($parameters));
    }

    /**
     * @param GetPurchaseOrdersByWarehouseAndConfirmedDate $parameters
     * @return GetPurchaseOrdersByWarehouseAndConfirmedDateResponse
     */
    public function GetPurchaseOrdersByWarehouseAndConfirmedDate(GetPurchaseOrdersByWarehouseAndConfirmedDate $parameters)
    {
      return $this->__soapCall('GetPurchaseOrdersByWarehouseAndConfirmedDate', array($parameters));
    }

    /**
     * @param SubmitPurchaseOrdersCustom $parameters
     * @return SubmitPurchaseOrdersResponse
     */
    public function SubmitPurchaseOrders($parameters)
    {
      return $this->__soapCall('SubmitPurchaseOrders', array($parameters));
    }

    /**
     * @param SubmitPurchaseOrderAction $parameters
     * @return SubmitPurchaseOrderActionResponse
     */
    public function SubmitPurchaseOrderAction(SubmitPurchaseOrderAction $parameters)
    {
      return $this->__soapCall('SubmitPurchaseOrderAction', array($parameters));
    }

    /**
     * @param SubmitPurchaseOrderActions $parameters
     * @return SubmitPurchaseOrderActionsResponse
     */
    public function SubmitPurchaseOrderActions(SubmitPurchaseOrderActions $parameters)
    {
      return $this->__soapCall('SubmitPurchaseOrderActions', array($parameters));
    }

    /**
     * @param GetWriteOnOffsByBranchDateCustom $parameters
     * @return GetWriteOnOffsByBranchDateResponse
     */
    public function GetWriteOnOffsByBranchDate($parameters)
    {
      return $this->__soapCall('GetWriteOnOffsByBranchDate', array($parameters));
    }

    /**
     * @param GetWriteOnOffsByDateCustom $parameters
     * @return GetWriteOnOffsByDateResponse
     */
    public function GetWriteOnOffsByDate($parameters)
    {
      return $this->__soapCall('GetWriteOnOffsByDate', array($parameters));
    }

    /**
     * @param GetWriteOnOffByIdentifierCustom $parameters
     * @return GetWriteOnOffByIdentifierResponse
     */
    public function GetWriteOnOffByIdentifier($parameters)
    {
      return $this->__soapCall('GetWriteOnOffByIdentifier', array($parameters));
    }

    /**
     * @param SubmitWriteOnOffsCustom $parameters
     * @return SubmitWriteOnOffsResponse
     */
    public function SubmitWriteOnOffs($parameters)
    {
      return $this->__soapCall('SubmitWriteOnOffs', array($parameters));
    }

    /**
     * @param SubmitReplenishmentTargetsCustom $parameters
     * @return SubmitReplenishmentTargetsResponse
     */
    public function SubmitReplenishmentTargets($parameters)
    {
      return $this->__soapCall('SubmitReplenishmentTargets', array($parameters));
    }

    /**
     * @param SubmitSkuReplenishmentCeilingsCustom $parameters
     * @return SubmitSkuReplenishmentCeilingsResponse
     */
    public function SubmitSkuReplenishmentCeilings($parameters)
    {
      return $this->__soapCall('SubmitSkuReplenishmentCeilings', array($parameters));
    }

    /**
     * @param FlagDataProcessingToRetryByReferenceCustom $parameters
     * @return FlagDataProcessingToRetryByReferenceResponse
     */
    public function FlagDataProcessingToRetryByReference($parameters)
    {
      return $this->__soapCall('FlagDataProcessingToRetryByReference', array($parameters));
    }

    /**
     * @param FlagDataProcessingToRetryByTokenCustom $parameters
     * @return FlagDataProcessingToRetryByTokenResponse
     */
    public function FlagDataProcessingToRetryByToken($parameters)
    {
      return $this->__soapCall('FlagDataProcessingToRetryByToken', array($parameters));
    }

    /**
     * @param RunDataProcessingByReferenceCustom $parameters
     * @return RunDataProcessingByReferenceResponse
     */
    public function RunDataProcessingByReference($parameters)
    {
      return $this->__soapCall('RunDataProcessingByReference', array($parameters));
    }

    /**
     * @param RunDataProcessingByTokenCustom $parameters
     * @return RunDataProcessingByTokenResponse
     */
    public function RunDataProcessingByToken($parameters)
    {
      return $this->__soapCall('RunDataProcessingByToken', array($parameters));
    }

}
