<?php

namespace Eurostop\Stocks;

class PurchaseOrderDetailCustom extends RetrievedDataItemOfPurchaseOrderDetailDto6qbTdoQxCustom
{

    /**
     * @var \DateTime $CommittedDeliveryEndDate
     */
    protected $CommittedDeliveryEndDate = null;

    /**
     * @var \DateTime $CommittedDeliveryStartDate
     */
    protected $CommittedDeliveryStartDate = null;

    /**
     * @var int $CommittedQuantity
     */
    protected $CommittedQuantity = null;

    /**
     * @var \DateTime $IntendedDeliveryEndDate
     */
    protected $IntendedDeliveryEndDate = null;

    /**
     * @var \DateTime $IntendedDeliveryStartDate
     */
    protected $IntendedDeliveryStartDate = null;

    /**
     * @var int $IntendedQuantity
     */
    protected $IntendedQuantity = null;

    /**
     * @var \DateTime $ModifiedDate
     */
    protected $ModifiedDate = null;

    /**
     * @var string $ProductIdentifier
     */
    protected $ProductIdentifier = null;

    /**
     * @var string $SkuIdentifier
     */
    protected $SkuIdentifier = null;

    /**
     * @var float $UnitCostPrice
     */
    protected $UnitCostPrice = null;

    /**
     * @param int $CommittedQuantity
     * @param int $IntendedQuantity
     * @param \DateTime $ModifiedDate
     * @param float $UnitCostPrice
     */
    public function __construct($CommittedQuantity, $IntendedQuantity, \DateTime $ModifiedDate, $UnitCostPrice)
    {
      parent::__construct();
      $this->CommittedQuantity = $CommittedQuantity;
      $this->IntendedQuantity = $IntendedQuantity;
      $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
      $this->UnitCostPrice = $UnitCostPrice;
    }

    /**
     * @return \DateTime
     */
    public function getCommittedDeliveryEndDate()
    {
      if ($this->CommittedDeliveryEndDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CommittedDeliveryEndDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CommittedDeliveryEndDate
     * @return \Eurostop\Stocks\PurchaseOrderDetail
     */
    public function setCommittedDeliveryEndDate(\DateTime $CommittedDeliveryEndDate = null)
    {
      if ($CommittedDeliveryEndDate == null) {
       $this->CommittedDeliveryEndDate = null;
      } else {
        $this->CommittedDeliveryEndDate = $CommittedDeliveryEndDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCommittedDeliveryStartDate()
    {
      if ($this->CommittedDeliveryStartDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->CommittedDeliveryStartDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $CommittedDeliveryStartDate
     * @return \Eurostop\Stocks\PurchaseOrderDetail
     */
    public function setCommittedDeliveryStartDate(\DateTime $CommittedDeliveryStartDate = null)
    {
      if ($CommittedDeliveryStartDate == null) {
       $this->CommittedDeliveryStartDate = null;
      } else {
        $this->CommittedDeliveryStartDate = $CommittedDeliveryStartDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getCommittedQuantity()
    {
      return $this->CommittedQuantity;
    }

    /**
     * @param int $CommittedQuantity
     * @return \Eurostop\Stocks\PurchaseOrderDetail
     */
    public function setCommittedQuantity($CommittedQuantity)
    {
      $this->CommittedQuantity = $CommittedQuantity;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getIntendedDeliveryEndDate()
    {
      if ($this->IntendedDeliveryEndDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->IntendedDeliveryEndDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $IntendedDeliveryEndDate
     * @return \Eurostop\Stocks\PurchaseOrderDetail
     */
    public function setIntendedDeliveryEndDate(\DateTime $IntendedDeliveryEndDate = null)
    {
      if ($IntendedDeliveryEndDate == null) {
       $this->IntendedDeliveryEndDate = null;
      } else {
        $this->IntendedDeliveryEndDate = $IntendedDeliveryEndDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getIntendedDeliveryStartDate()
    {
      if ($this->IntendedDeliveryStartDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->IntendedDeliveryStartDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $IntendedDeliveryStartDate
     * @return \Eurostop\Stocks\PurchaseOrderDetail
     */
    public function setIntendedDeliveryStartDate(\DateTime $IntendedDeliveryStartDate = null)
    {
      if ($IntendedDeliveryStartDate == null) {
       $this->IntendedDeliveryStartDate = null;
      } else {
        $this->IntendedDeliveryStartDate = $IntendedDeliveryStartDate->format(\DateTime::ATOM);
      }
      return $this;
    }

    /**
     * @return int
     */
    public function getIntendedQuantity()
    {
      return $this->IntendedQuantity;
    }

    /**
     * @param int $IntendedQuantity
     * @return \Eurostop\Stocks\PurchaseOrderDetail
     */
    public function setIntendedQuantity($IntendedQuantity)
    {
      $this->IntendedQuantity = $IntendedQuantity;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedDate()
    {
      if ($this->ModifiedDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->ModifiedDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $ModifiedDate
     * @return \Eurostop\Stocks\PurchaseOrderDetail
     */
    public function setModifiedDate(\DateTime $ModifiedDate)
    {
      $this->ModifiedDate = $ModifiedDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->ProductIdentifier;
    }

    /**
     * @param string $ProductIdentifier
     * @return \Eurostop\Stocks\PurchaseOrderDetail
     */
    public function setProductIdentifier($ProductIdentifier)
    {
      $this->ProductIdentifier = $ProductIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->SkuIdentifier;
    }

    /**
     * @param string $SkuIdentifier
     * @return \Eurostop\Stocks\PurchaseOrderDetail
     */
    public function setSkuIdentifier($SkuIdentifier)
    {
      $this->SkuIdentifier = $SkuIdentifier;
      return $this;
    }

    /**
     * @return float
     */
    public function getUnitCostPrice()
    {
      return $this->UnitCostPrice;
    }

    /**
     * @param float $UnitCostPrice
     * @return \Eurostop\Stocks\PurchaseOrderDetail
     */
    public function setUnitCostPrice($UnitCostPrice)
    {
      $this->UnitCostPrice = $UnitCostPrice;
      return $this;
    }

}
