<?php

namespace Eurostop\Stocks;

class GetPurchaseOrdersByWarehouseAndDateCustom
{

    /**
     * @var string $warehouseIdentifier
     */
    protected $warehouseIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $startDate
     */
    protected $startDate = null;

    /**
     * @var \DateTime $endDate
     */
    protected $endDate = null;

    /**
     * @var boolean $includeUnConfirmed
     */
    protected $includeUnConfirmed = null;

    /**
     * @param string $warehouseIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $startDate
     * @param \DateTime $endDate
     * @param boolean $includeUnConfirmed
     */
    public function __construct($warehouseIdentifier, $branchIdentifierType, \DateTime $startDate, \DateTime $endDate, $includeUnConfirmed)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->startDate = $startDate->format(\DateTime::ATOM);
      $this->endDate = $endDate->format(\DateTime::ATOM);
      $this->includeUnConfirmed = $includeUnConfirmed;
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->warehouseIdentifier;
    }

    /**
     * @param string $warehouseIdentifier
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouseAndDate
     */
    public function setWarehouseIdentifier($warehouseIdentifier)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouseAndDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->startDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->startDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $startDate
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouseAndDate
     */
    public function setStartDate(\DateTime $startDate)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->endDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->endDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $endDate
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouseAndDate
     */
    public function setEndDate(\DateTime $endDate)
    {
      $this->endDate = $endDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeUnConfirmed()
    {
      return $this->includeUnConfirmed;
    }

    /**
     * @param boolean $includeUnConfirmed
     * @return \Eurostop\Stocks\GetPurchaseOrdersByWarehouseAndDate
     */
    public function setIncludeUnConfirmed($includeUnConfirmed)
    {
      $this->includeUnConfirmed = $includeUnConfirmed;
      return $this;
    }

}
