<?php

namespace Eurostop\Stocks;

class GetInOutTransfersByBranchConfirmedDate
{

    /**
     * @var string $fromBranchIdentifier
     */
    protected $fromBranchIdentifier = null;

    /**
     * @var string $toBranchIdentifier
     */
    protected $toBranchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $confirmedFromDate
     */
    protected $confirmedFromDate = null;

    /**
     * @var \DateTime $confirmedToDate
     */
    protected $confirmedToDate = null;

    /**
     * @var boolean $includeTransfersOut
     */
    protected $includeTransfersOut = null;

    /**
     * @var boolean $includeTransfersIn
     */
    protected $includeTransfersIn = null;

    /**
     * @param string $fromBranchIdentifier
     * @param string $toBranchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $confirmedFromDate
     * @param \DateTime $confirmedToDate
     * @param boolean $includeTransfersOut
     * @param boolean $includeTransfersIn
     */
    public function __construct($fromBranchIdentifier, $toBranchIdentifier, $branchIdentifierType, \DateTime $confirmedFromDate, \DateTime $confirmedToDate, $includeTransfersOut, $includeTransfersIn)
    {
      $this->fromBranchIdentifier = $fromBranchIdentifier;
      $this->toBranchIdentifier = $toBranchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->confirmedFromDate = $confirmedFromDate->format(\DateTime::ATOM);
      $this->confirmedToDate = $confirmedToDate->format(\DateTime::ATOM);
      $this->includeTransfersOut = $includeTransfersOut;
      $this->includeTransfersIn = $includeTransfersIn;
    }

    /**
     * @return string
     */
    public function getFromBranchIdentifier()
    {
      return $this->fromBranchIdentifier;
    }

    /**
     * @param string $fromBranchIdentifier
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchConfirmedDate
     */
    public function setFromBranchIdentifier($fromBranchIdentifier)
    {
      $this->fromBranchIdentifier = $fromBranchIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getToBranchIdentifier()
    {
      return $this->toBranchIdentifier;
    }

    /**
     * @param string $toBranchIdentifier
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchConfirmedDate
     */
    public function setToBranchIdentifier($toBranchIdentifier)
    {
      $this->toBranchIdentifier = $toBranchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchConfirmedDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedFromDate()
    {
      if ($this->confirmedFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->confirmedFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $confirmedFromDate
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchConfirmedDate
     */
    public function setConfirmedFromDate(\DateTime $confirmedFromDate)
    {
      $this->confirmedFromDate = $confirmedFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getConfirmedToDate()
    {
      if ($this->confirmedToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->confirmedToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $confirmedToDate
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchConfirmedDate
     */
    public function setConfirmedToDate(\DateTime $confirmedToDate)
    {
      $this->confirmedToDate = $confirmedToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersOut()
    {
      return $this->includeTransfersOut;
    }

    /**
     * @param boolean $includeTransfersOut
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchConfirmedDate
     */
    public function setIncludeTransfersOut($includeTransfersOut)
    {
      $this->includeTransfersOut = $includeTransfersOut;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersIn()
    {
      return $this->includeTransfersIn;
    }

    /**
     * @param boolean $includeTransfersIn
     * @return \Eurostop\Stocks\GetInOutTransfersByBranchConfirmedDate
     */
    public function setIncludeTransfersIn($includeTransfersIn)
    {
      $this->includeTransfersIn = $includeTransfersIn;
      return $this;
    }

}
