<?php

namespace Eurostop\Stocks;

class GetInOutTransferByIdentifier
{

    /**
     * @var string $transferIdentifier
     */
    protected $transferIdentifier = null;

    /**
     * @var TransferIdentifierType $transferIdentifierType
     */
    protected $transferIdentifierType = null;

    /**
     * @var boolean $includeTransfersOut
     */
    protected $includeTransfersOut = null;

    /**
     * @var boolean $includeTransfersIn
     */
    protected $includeTransfersIn = null;

    /**
     * @param string $transferIdentifier
     * @param TransferIdentifierType $transferIdentifierType
     * @param boolean $includeTransfersOut
     * @param boolean $includeTransfersIn
     */
    public function __construct($transferIdentifier = null, $transferIdentifierType = null, $includeTransfersOut = null, $includeTransfersIn = null)
    {
      $this->transferIdentifier = $transferIdentifier;
      $this->transferIdentifierType = $transferIdentifierType;
      $this->includeTransfersOut = $includeTransfersOut;
      $this->includeTransfersIn = $includeTransfersIn;
    }

    /**
     * @return string
     */
    public function getTransferIdentifier()
    {
      return $this->transferIdentifier;
    }

    /**
     * @param string $transferIdentifier
     * @return \Eurostop\Stocks\GetInOutTransferByIdentifier
     */
    public function setTransferIdentifier($transferIdentifier)
    {
      $this->transferIdentifier = $transferIdentifier;
      return $this;
    }

    /**
     * @return TransferIdentifierType
     */
    public function getTransferIdentifierType()
    {
      return $this->transferIdentifierType;
    }

    /**
     * @param TransferIdentifierType $transferIdentifierType
     * @return \Eurostop\Stocks\GetInOutTransferByIdentifier
     */
    public function setTransferIdentifierType($transferIdentifierType)
    {
      $this->transferIdentifierType = $transferIdentifierType;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersOut()
    {
      return $this->includeTransfersOut;
    }

    /**
     * @param boolean $includeTransfersOut
     * @return \Eurostop\Stocks\GetInOutTransferByIdentifier
     */
    public function setIncludeTransfersOut($includeTransfersOut)
    {
      $this->includeTransfersOut = $includeTransfersOut;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIncludeTransfersIn()
    {
      return $this->includeTransfersIn;
    }

    /**
     * @param boolean $includeTransfersIn
     * @return \Eurostop\Stocks\GetInOutTransferByIdentifier
     */
    public function setIncludeTransfersIn($includeTransfersIn)
    {
      $this->includeTransfersIn = $includeTransfersIn;
      return $this;
    }

}
