<?php

namespace Eurostop\Stocks;

class GetDeliveryByIdentifierCustom
{

    /**
     * @var string $deliveryIdentifier
     */
    protected $deliveryIdentifier = null;

    /**
     * @var DeliveryIdentifierType $deliveryIdentifierType
     */
    protected $deliveryIdentifierType = null;

    /**
     * @param string $deliveryIdentifier
     * @param DeliveryIdentifierType $deliveryIdentifierType
     */
    public function __construct($deliveryIdentifier, $deliveryIdentifierType)
    {
      $this->deliveryIdentifier = $deliveryIdentifier;
      $this->deliveryIdentifierType = $deliveryIdentifierType;
    }

    /**
     * @return string
     */
    public function getDeliveryIdentifier()
    {
      return $this->deliveryIdentifier;
    }

    /**
     * @param string $deliveryIdentifier
     * @return \Eurostop\Stocks\GetDeliveryByIdentifier
     */
    public function setDeliveryIdentifier($deliveryIdentifier)
    {
      $this->deliveryIdentifier = $deliveryIdentifier;
      return $this;
    }

    /**
     * @return DeliveryIdentifierType
     */
    public function getDeliveryIdentifierType()
    {
      return $this->deliveryIdentifierType;
    }

    /**
     * @param DeliveryIdentifierType $deliveryIdentifierType
     * @return \Eurostop\Stocks\GetDeliveryByIdentifier
     */
    public function setDeliveryIdentifierType($deliveryIdentifierType)
    {
      $this->deliveryIdentifierType = $deliveryIdentifierType;
      return $this;
    }

}
