<?php

namespace Eurostop\Stocks;

class GetCurrentStockPositionByBranchGroupAndSku
{

    /**
     * @var string $branchGroupIdentifier
     */
    protected $branchGroupIdentifier = null;

    /**
     * @var BranchGroupIdentifierType $branchGroupIdentifierType
     */
    protected $branchGroupIdentifierType = null;

    /**
     * @var string $skuIdentifier
     */
    protected $skuIdentifier = null;

    /**
     * @var SkuIdentifierType $skuIdentifierType
     */
    protected $skuIdentifierType = null;

    /**
     * @param string $branchGroupIdentifier
     * @param BranchGroupIdentifierType $branchGroupIdentifierType
     * @param string $skuIdentifier
     * @param SkuIdentifierType $skuIdentifierType
     */
    public function __construct($branchGroupIdentifier = null, $branchGroupIdentifierType = null, $skuIdentifier = null, $skuIdentifierType = null)
    {
      $this->branchGroupIdentifier = $branchGroupIdentifier;
      $this->branchGroupIdentifierType = $branchGroupIdentifierType;
      $this->skuIdentifier = $skuIdentifier;
      $this->skuIdentifierType = $skuIdentifierType;
    }

    /**
     * @return string
     */
    public function getBranchGroupIdentifier()
    {
      return $this->branchGroupIdentifier;
    }

    /**
     * @param string $branchGroupIdentifier
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndSku
     */
    public function setBranchGroupIdentifier($branchGroupIdentifier)
    {
      $this->branchGroupIdentifier = $branchGroupIdentifier;
      return $this;
    }

    /**
     * @return BranchGroupIdentifierType
     */
    public function getBranchGroupIdentifierType()
    {
      return $this->branchGroupIdentifierType;
    }

    /**
     * @param BranchGroupIdentifierType $branchGroupIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndSku
     */
    public function setBranchGroupIdentifierType($branchGroupIdentifierType)
    {
      $this->branchGroupIdentifierType = $branchGroupIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->skuIdentifier;
    }

    /**
     * @param string $skuIdentifier
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndSku
     */
    public function setSkuIdentifier($skuIdentifier)
    {
      $this->skuIdentifier = $skuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->skuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $skuIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndSku
     */
    public function setSkuIdentifierType($skuIdentifierType)
    {
      $this->skuIdentifierType = $skuIdentifierType;
      return $this;
    }

}
