<?php

namespace Eurostop\Stocks;

class GetCurrentStockPositionByBranchGroupAndProduct
{

    /**
     * @var string $branchGroupIdentifier
     */
    protected $branchGroupIdentifier = null;

    /**
     * @var BranchGroupIdentifierType $branchGroupIdentifierType
     */
    protected $branchGroupIdentifierType = null;

    /**
     * @var string $productIdentifier
     */
    protected $productIdentifier = null;

    /**
     * @var ProductIdentifierType $productIdentifierType
     */
    protected $productIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @param string $branchGroupIdentifier
     * @param BranchGroupIdentifierType $branchGroupIdentifierType
     * @param string $productIdentifier
     * @param ProductIdentifierType $productIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     */
    public function __construct($branchGroupIdentifier = null, $branchGroupIdentifierType = null, $productIdentifier = null, $productIdentifierType = null, \DateTime $modifiedSinceDate = null, $nonZeroOnly = null)
    {
      $this->branchGroupIdentifier = $branchGroupIdentifier;
      $this->branchGroupIdentifierType = $branchGroupIdentifierType;
      $this->productIdentifier = $productIdentifier;
      $this->productIdentifierType = $productIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate ? $modifiedSinceDate->format(\DateTime::ATOM) : null;
      $this->nonZeroOnly = $nonZeroOnly;
    }

    /**
     * @return string
     */
    public function getBranchGroupIdentifier()
    {
      return $this->branchGroupIdentifier;
    }

    /**
     * @param string $branchGroupIdentifier
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProduct
     */
    public function setBranchGroupIdentifier($branchGroupIdentifier)
    {
      $this->branchGroupIdentifier = $branchGroupIdentifier;
      return $this;
    }

    /**
     * @return BranchGroupIdentifierType
     */
    public function getBranchGroupIdentifierType()
    {
      return $this->branchGroupIdentifierType;
    }

    /**
     * @param BranchGroupIdentifierType $branchGroupIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProduct
     */
    public function setBranchGroupIdentifierType($branchGroupIdentifierType)
    {
      $this->branchGroupIdentifierType = $branchGroupIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getProductIdentifier()
    {
      return $this->productIdentifier;
    }

    /**
     * @param string $productIdentifier
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProduct
     */
    public function setProductIdentifier($productIdentifier)
    {
      $this->productIdentifier = $productIdentifier;
      return $this;
    }

    /**
     * @return ProductIdentifierType
     */
    public function getProductIdentifierType()
    {
      return $this->productIdentifierType;
    }

    /**
     * @param ProductIdentifierType $productIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProduct
     */
    public function setProductIdentifierType($productIdentifierType)
    {
      $this->productIdentifierType = $productIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProduct
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchGroupAndProduct
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

}
