<?php

namespace Eurostop\Stocks;

class GetCurrentStockPositionByBranchAndProductList
{

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var ArrayOfstring $productIdentifiers
     */
    protected $productIdentifiers = null;

    /**
     * @var ProductIdentifierType $productIdentifierType
     */
    protected $productIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param ArrayOfstring $productIdentifiers
     * @param ProductIdentifierType $productIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     */
    public function __construct($branchIdentifier = null, $branchIdentifierType = null, $productIdentifiers = null, $productIdentifierType = null, \DateTime $modifiedSinceDate = null, $nonZeroOnly = null)
    {
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->productIdentifiers = $productIdentifiers;
      $this->productIdentifierType = $productIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate ? $modifiedSinceDate->format(\DateTime::ATOM) : null;
      $this->nonZeroOnly = $nonZeroOnly;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchAndProductList
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchAndProductList
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getProductIdentifiers()
    {
      return $this->productIdentifiers;
    }

    /**
     * @param ArrayOfstring $productIdentifiers
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchAndProductList
     */
    public function setProductIdentifiers($productIdentifiers)
    {
      $this->productIdentifiers = $productIdentifiers;
      return $this;
    }

    /**
     * @return ProductIdentifierType
     */
    public function getProductIdentifierType()
    {
      return $this->productIdentifierType;
    }

    /**
     * @param ProductIdentifierType $productIdentifierType
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchAndProductList
     */
    public function setProductIdentifierType($productIdentifierType)
    {
      $this->productIdentifierType = $productIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchAndProductList
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentStockPositionByBranchAndProductList
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

}
