<?php

namespace Eurostop\Stocks;

class GetCurrentSkuStockByBranchListAndSku
{

    /**
     * @var ArrayOfstring $branchIdentifiers
     */
    protected $branchIdentifiers = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var string $skuIdentifier
     */
    protected $skuIdentifier = null;

    /**
     * @var SkuIdentifierType $skuIdentifierType
     */
    protected $skuIdentifierType = null;

    /**
     * @param ArrayOfstring $branchIdentifiers
     * @param BranchIdentifierType $branchIdentifierType
     * @param string $skuIdentifier
     * @param SkuIdentifierType $skuIdentifierType
     */
    public function __construct($branchIdentifiers, $branchIdentifierType, $skuIdentifier, $skuIdentifierType)
    {
      $this->branchIdentifiers = $branchIdentifiers;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->skuIdentifier = $skuIdentifier;
      $this->skuIdentifierType = $skuIdentifierType;
    }

    /**
     * @return ArrayOfstring
     */
    public function getBranchIdentifiers()
    {
      return $this->branchIdentifiers;
    }

    /**
     * @param ArrayOfstring $branchIdentifiers
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchListAndSku
     */
    public function setBranchIdentifiers($branchIdentifiers)
    {
      $this->branchIdentifiers = $branchIdentifiers;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchListAndSku
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getSkuIdentifier()
    {
      return $this->skuIdentifier;
    }

    /**
     * @param string $skuIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchListAndSku
     */
    public function setSkuIdentifier($skuIdentifier)
    {
      $this->skuIdentifier = $skuIdentifier;
      return $this;
    }

    /**
     * @return SkuIdentifierType
     */
    public function getSkuIdentifierType()
    {
      return $this->skuIdentifierType;
    }

    /**
     * @param SkuIdentifierType $skuIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchListAndSku
     */
    public function setSkuIdentifierType($skuIdentifierType)
    {
      $this->skuIdentifierType = $skuIdentifierType;
      return $this;
    }

}
