<?php

namespace Eurostop\Stocks;

class GetCurrentSkuStockByBranchGroupAndProductListCustom
{

    /**
     * @var string $branchGroupIdentifier
     */
    protected $branchGroupIdentifier = null;

    /**
     * @var BranchGroupIdentifierType $branchGroupIdentifierType
     */
    protected $branchGroupIdentifierType = null;

    /**
     * @var ArrayOfstring $productIdentifiers
     */
    protected $productIdentifiers = null;

    /**
     * @var ProductIdentifierType $productIdentifierType
     */
    protected $productIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @param string $branchGroupIdentifier
     * @param BranchGroupIdentifierType $branchGroupIdentifierType
     * @param ArrayOfstring $productIdentifiers
     * @param ProductIdentifierType $productIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     */
    public function __construct($branchGroupIdentifier, $branchGroupIdentifierType, $productIdentifiers, $productIdentifierType, \DateTime $modifiedSinceDate, $nonZeroOnly)
    {
      $this->branchGroupIdentifier = $branchGroupIdentifier;
      $this->branchGroupIdentifierType = $branchGroupIdentifierType;
      $this->productIdentifiers = $productIdentifiers;
      $this->productIdentifierType = $productIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->nonZeroOnly = $nonZeroOnly;
    }

    /**
     * @return string
     */
    public function getBranchGroupIdentifier()
    {
      return $this->branchGroupIdentifier;
    }

    /**
     * @param string $branchGroupIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndProductList
     */
    public function setBranchGroupIdentifier($branchGroupIdentifier)
    {
      $this->branchGroupIdentifier = $branchGroupIdentifier;
      return $this;
    }

    /**
     * @return BranchGroupIdentifierType
     */
    public function getBranchGroupIdentifierType()
    {
      return $this->branchGroupIdentifierType;
    }

    /**
     * @param BranchGroupIdentifierType $branchGroupIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndProductList
     */
    public function setBranchGroupIdentifierType($branchGroupIdentifierType)
    {
      $this->branchGroupIdentifierType = $branchGroupIdentifierType;
      return $this;
    }

    /**
     * @return ArrayOfstring
     */
    public function getProductIdentifiers()
    {
      return $this->productIdentifiers;
    }

    /**
     * @param ArrayOfstring $productIdentifiers
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndProductList
     */
    public function setProductIdentifiers($productIdentifiers)
    {
      $this->productIdentifiers = $productIdentifiers;
      return $this;
    }

    /**
     * @return ProductIdentifierType
     */
    public function getProductIdentifierType()
    {
      return $this->productIdentifierType;
    }

    /**
     * @param ProductIdentifierType $productIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndProductList
     */
    public function setProductIdentifierType($productIdentifierType)
    {
      $this->productIdentifierType = $productIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndProductList
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchGroupAndProductList
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

}
