<?php

namespace Eurostop\Stocks;

class GetCurrentSkuStockByBranchAndHierarchyNodeCustom
{

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var string $level1HierarchyNodeIdentifier
     */
    protected $level1HierarchyNodeIdentifier = null;

    /**
     * @var string $level2HierarchyNodeIdentifier
     */
    protected $level2HierarchyNodeIdentifier = null;

    /**
     * @var string $level3HierarchyNodeIdentifier
     */
    protected $level3HierarchyNodeIdentifier = null;

    /**
     * @var string $level4HierarchyNodeIdentifier
     */
    protected $level4HierarchyNodeIdentifier = null;

    /**
     * @var HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     */
    protected $hierarchyNodeIdentifierType = null;

    /**
     * @var \DateTime $modifiedSinceDate
     */
    protected $modifiedSinceDate = null;

    /**
     * @var boolean $nonZeroOnly
     */
    protected $nonZeroOnly = null;

    /**
     * @var int $maxPositions
     */
    protected $maxPositions = null;

    /**
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param string $level1HierarchyNodeIdentifier
     * @param string $level2HierarchyNodeIdentifier
     * @param string $level3HierarchyNodeIdentifier
     * @param string $level4HierarchyNodeIdentifier
     * @param HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     * @param \DateTime $modifiedSinceDate
     * @param boolean $nonZeroOnly
     * @param int $maxPositions
     */
    public function __construct($branchIdentifier, $branchIdentifierType, $level1HierarchyNodeIdentifier, $level2HierarchyNodeIdentifier, $level3HierarchyNodeIdentifier, $level4HierarchyNodeIdentifier, $hierarchyNodeIdentifierType, \DateTime $modifiedSinceDate, $nonZeroOnly, $maxPositions)
    {
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->level1HierarchyNodeIdentifier = $level1HierarchyNodeIdentifier;
      $this->level2HierarchyNodeIdentifier = $level2HierarchyNodeIdentifier;
      $this->level3HierarchyNodeIdentifier = $level3HierarchyNodeIdentifier;
      $this->level4HierarchyNodeIdentifier = $level4HierarchyNodeIdentifier;
      $this->hierarchyNodeIdentifierType = $hierarchyNodeIdentifierType;
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      $this->nonZeroOnly = $nonZeroOnly;
      $this->maxPositions = $maxPositions;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchAndHierarchyNode
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchAndHierarchyNode
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return string
     */
    public function getLevel1HierarchyNodeIdentifier()
    {
      return $this->level1HierarchyNodeIdentifier;
    }

    /**
     * @param string $level1HierarchyNodeIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchAndHierarchyNode
     */
    public function setLevel1HierarchyNodeIdentifier($level1HierarchyNodeIdentifier)
    {
      $this->level1HierarchyNodeIdentifier = $level1HierarchyNodeIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getLevel2HierarchyNodeIdentifier()
    {
      return $this->level2HierarchyNodeIdentifier;
    }

    /**
     * @param string $level2HierarchyNodeIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchAndHierarchyNode
     */
    public function setLevel2HierarchyNodeIdentifier($level2HierarchyNodeIdentifier)
    {
      $this->level2HierarchyNodeIdentifier = $level2HierarchyNodeIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getLevel3HierarchyNodeIdentifier()
    {
      return $this->level3HierarchyNodeIdentifier;
    }

    /**
     * @param string $level3HierarchyNodeIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchAndHierarchyNode
     */
    public function setLevel3HierarchyNodeIdentifier($level3HierarchyNodeIdentifier)
    {
      $this->level3HierarchyNodeIdentifier = $level3HierarchyNodeIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getLevel4HierarchyNodeIdentifier()
    {
      return $this->level4HierarchyNodeIdentifier;
    }

    /**
     * @param string $level4HierarchyNodeIdentifier
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchAndHierarchyNode
     */
    public function setLevel4HierarchyNodeIdentifier($level4HierarchyNodeIdentifier)
    {
      $this->level4HierarchyNodeIdentifier = $level4HierarchyNodeIdentifier;
      return $this;
    }

    /**
     * @return HierarchyNodeIdentifierType
     */
    public function getHierarchyNodeIdentifierType()
    {
      return $this->hierarchyNodeIdentifierType;
    }

    /**
     * @param HierarchyNodeIdentifierType $hierarchyNodeIdentifierType
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchAndHierarchyNode
     */
    public function setHierarchyNodeIdentifierType($hierarchyNodeIdentifierType)
    {
      $this->hierarchyNodeIdentifierType = $hierarchyNodeIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getModifiedSinceDate()
    {
      if ($this->modifiedSinceDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->modifiedSinceDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $modifiedSinceDate
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchAndHierarchyNode
     */
    public function setModifiedSinceDate(\DateTime $modifiedSinceDate)
    {
      $this->modifiedSinceDate = $modifiedSinceDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return boolean
     */
    public function getNonZeroOnly()
    {
      return $this->nonZeroOnly;
    }

    /**
     * @param boolean $nonZeroOnly
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchAndHierarchyNode
     */
    public function setNonZeroOnly($nonZeroOnly)
    {
      $this->nonZeroOnly = $nonZeroOnly;
      return $this;
    }

    /**
     * @return int
     */
    public function getMaxPositions()
    {
      return $this->maxPositions;
    }

    /**
     * @param int $maxPositions
     * @return \Eurostop\Stocks\GetCurrentSkuStockByBranchAndHierarchyNode
     */
    public function setMaxPositions($maxPositions)
    {
      $this->maxPositions = $maxPositions;
      return $this;
    }

}
