<?php

namespace Eurostop\Stocks;

class GetConsolidatedTransferByIdentifier
{

    /**
     * @var string $transferIdentifier
     */
    protected $transferIdentifier = null;

    /**
     * @var TransferIdentifierType $transferIdentifierType
     */
    protected $transferIdentifierType = null;

    /**
     * @param string $transferIdentifier
     * @param TransferIdentifierType $transferIdentifierType
     */
    public function __construct($transferIdentifier = null, $transferIdentifierType = null)
    {
      $this->transferIdentifier = $transferIdentifier;
      $this->transferIdentifierType = $transferIdentifierType;
    }

    /**
     * @return string
     */
    public function getTransferIdentifier()
    {
      return $this->transferIdentifier;
    }

    /**
     * @param string $transferIdentifier
     * @return \Eurostop\Stocks\GetConsolidatedTransferByIdentifier
     */
    public function setTransferIdentifier($transferIdentifier)
    {
      $this->transferIdentifier = $transferIdentifier;
      return $this;
    }

    /**
     * @return TransferIdentifierType
     */
    public function getTransferIdentifierType()
    {
      return $this->transferIdentifierType;
    }

    /**
     * @param TransferIdentifierType $transferIdentifierType
     * @return \Eurostop\Stocks\GetConsolidatedTransferByIdentifier
     */
    public function setTransferIdentifierType($transferIdentifierType)
    {
      $this->transferIdentifierType = $transferIdentifierType;
      return $this;
    }

}
