<?php

namespace Eurostop\Stocks;

class GetAllocationsByWarehouseAndDate
{

    /**
     * @var string $warehouseIdentifier
     */
    protected $warehouseIdentifier = null;

    /**
     * @var BranchIdentifierType $warehouseIdentifierType
     */
    protected $warehouseIdentifierType = null;

    /**
     * @var \DateTime $startDate
     */
    protected $startDate = null;

    /**
     * @var \DateTime $endDate
     */
    protected $endDate = null;

    /**
     * @param string $warehouseIdentifier
     * @param BranchIdentifierType $warehouseIdentifierType
     * @param \DateTime $startDate
     * @param \DateTime $endDate
     */
    public function __construct($warehouseIdentifier, $warehouseIdentifierType, \DateTime $startDate, \DateTime $endDate)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      $this->warehouseIdentifierType = $warehouseIdentifierType;
      $this->startDate = $startDate->format(\DateTime::ATOM);
      $this->endDate = $endDate->format(\DateTime::ATOM);
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->warehouseIdentifier;
    }

    /**
     * @param string $warehouseIdentifier
     * @return \Eurostop\Stocks\GetAllocationsByWarehouseAndDate
     */
    public function setWarehouseIdentifier($warehouseIdentifier)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getWarehouseIdentifierType()
    {
      return $this->warehouseIdentifierType;
    }

    /**
     * @param BranchIdentifierType $warehouseIdentifierType
     * @return \Eurostop\Stocks\GetAllocationsByWarehouseAndDate
     */
    public function setWarehouseIdentifierType($warehouseIdentifierType)
    {
      $this->warehouseIdentifierType = $warehouseIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getStartDate()
    {
      if ($this->startDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->startDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $startDate
     * @return \Eurostop\Stocks\GetAllocationsByWarehouseAndDate
     */
    public function setStartDate(\DateTime $startDate)
    {
      $this->startDate = $startDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndDate()
    {
      if ($this->endDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->endDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $endDate
     * @return \Eurostop\Stocks\GetAllocationsByWarehouseAndDate
     */
    public function setEndDate(\DateTime $endDate)
    {
      $this->endDate = $endDate->format(\DateTime::ATOM);
      return $this;
    }

}
