<?php

namespace Eurostop\Stocks;

class GetAllocationByIdentifier
{

    /**
     * @var string $allocationIdentifier
     */
    protected $allocationIdentifier = null;

    /**
     * @var AllocationIdentifierType $allocationIdentifierType
     */
    protected $allocationIdentifierType = null;

    /**
     * @param string $allocationIdentifier
     * @param AllocationIdentifierType $allocationIdentifierType
     */
    public function __construct($allocationIdentifier, $allocationIdentifierType)
    {
      $this->allocationIdentifier = $allocationIdentifier;
      $this->allocationIdentifierType = $allocationIdentifierType;
    }

    /**
     * @return string
     */
    public function getAllocationIdentifier()
    {
      return $this->allocationIdentifier;
    }

    /**
     * @param string $allocationIdentifier
     * @return \Eurostop\Stocks\GetAllocationByIdentifier
     */
    public function setAllocationIdentifier($allocationIdentifier)
    {
      $this->allocationIdentifier = $allocationIdentifier;
      return $this;
    }

    /**
     * @return AllocationIdentifierType
     */
    public function getAllocationIdentifierType()
    {
      return $this->allocationIdentifierType;
    }

    /**
     * @param AllocationIdentifierType $allocationIdentifierType
     * @return \Eurostop\Stocks\GetAllocationByIdentifier
     */
    public function setAllocationIdentifierType($allocationIdentifierType)
    {
      $this->allocationIdentifierType = $allocationIdentifierType;
      return $this;
    }

}
