<?php

namespace Eurostop\Stocks;

class GetAdviceNotesByBranchCreatedDate
{

    /**
     * @var string $warehouseIdentifier
     */
    protected $warehouseIdentifier = null;

    /**
     * @var string $branchIdentifier
     */
    protected $branchIdentifier = null;

    /**
     * @var BranchIdentifierType $branchIdentifierType
     */
    protected $branchIdentifierType = null;

    /**
     * @var \DateTime $createdFromDate
     */
    protected $createdFromDate = null;

    /**
     * @var \DateTime $createdToDate
     */
    protected $createdToDate = null;

    /**
     * @var AdviceNoteStatus $status
     */
    protected $status = null;

    /**
     * @var boolean $isClosed
     */
    protected $isClosed = null;

    /**
     * @param string $warehouseIdentifier
     * @param string $branchIdentifier
     * @param BranchIdentifierType $branchIdentifierType
     * @param \DateTime $createdFromDate
     * @param \DateTime $createdToDate
     * @param AdviceNoteStatus $status
     * @param boolean $isClosed
     */
    public function __construct($warehouseIdentifier, $branchIdentifier, $branchIdentifierType, \DateTime $createdFromDate, \DateTime $createdToDate, $status, $isClosed)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      $this->branchIdentifier = $branchIdentifier;
      $this->branchIdentifierType = $branchIdentifierType;
      $this->createdFromDate = $createdFromDate->format(\DateTime::ATOM);
      $this->createdToDate = $createdToDate->format(\DateTime::ATOM);
      $this->status = $status;
      $this->isClosed = $isClosed;
    }

    /**
     * @return string
     */
    public function getWarehouseIdentifier()
    {
      return $this->warehouseIdentifier;
    }

    /**
     * @param string $warehouseIdentifier
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchCreatedDate
     */
    public function setWarehouseIdentifier($warehouseIdentifier)
    {
      $this->warehouseIdentifier = $warehouseIdentifier;
      return $this;
    }

    /**
     * @return string
     */
    public function getBranchIdentifier()
    {
      return $this->branchIdentifier;
    }

    /**
     * @param string $branchIdentifier
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchCreatedDate
     */
    public function setBranchIdentifier($branchIdentifier)
    {
      $this->branchIdentifier = $branchIdentifier;
      return $this;
    }

    /**
     * @return BranchIdentifierType
     */
    public function getBranchIdentifierType()
    {
      return $this->branchIdentifierType;
    }

    /**
     * @param BranchIdentifierType $branchIdentifierType
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchCreatedDate
     */
    public function setBranchIdentifierType($branchIdentifierType)
    {
      $this->branchIdentifierType = $branchIdentifierType;
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedFromDate()
    {
      if ($this->createdFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->createdFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $createdFromDate
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchCreatedDate
     */
    public function setCreatedFromDate(\DateTime $createdFromDate)
    {
      $this->createdFromDate = $createdFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedToDate()
    {
      if ($this->createdToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->createdToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $createdToDate
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchCreatedDate
     */
    public function setCreatedToDate(\DateTime $createdToDate)
    {
      $this->createdToDate = $createdToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return AdviceNoteStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param AdviceNoteStatus $status
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchCreatedDate
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsClosed()
    {
      return $this->isClosed;
    }

    /**
     * @param boolean $isClosed
     * @return \Eurostop\Stocks\GetAdviceNotesByBranchCreatedDate
     */
    public function setIsClosed($isClosed)
    {
      $this->isClosed = $isClosed;
      return $this;
    }

}
