<?php

namespace Eurostop\Stocks;

class GetAdviceNotesByBookedInDate
{

    /**
     * @var \DateTime $bookedInFromDate
     */
    protected $bookedInFromDate = null;

    /**
     * @var \DateTime $bookedInToDate
     */
    protected $bookedInToDate = null;

    /**
     * @var AdviceNoteStatus $status
     */
    protected $status = null;

    /**
     * @var boolean $isClosed
     */
    protected $isClosed = null;

    /**
     * @param \DateTime $bookedInFromDate
     * @param \DateTime $bookedInToDate
     * @param AdviceNoteStatus $status
     * @param boolean $isClosed
     */
    public function __construct(\DateTime $bookedInFromDate, \DateTime $bookedInToDate, $status, $isClosed)
    {
      $this->bookedInFromDate = $bookedInFromDate->format(\DateTime::ATOM);
      $this->bookedInToDate = $bookedInToDate->format(\DateTime::ATOM);
      $this->status = $status;
      $this->isClosed = $isClosed;
    }

    /**
     * @return \DateTime
     */
    public function getBookedInFromDate()
    {
      if ($this->bookedInFromDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->bookedInFromDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $bookedInFromDate
     * @return \Eurostop\Stocks\GetAdviceNotesByBookedInDate
     */
    public function setBookedInFromDate(\DateTime $bookedInFromDate)
    {
      $this->bookedInFromDate = $bookedInFromDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBookedInToDate()
    {
      if ($this->bookedInToDate == null) {
        return null;
      } else {
        try {
          return new \DateTime($this->bookedInToDate);
        } catch (\Exception $e) {
          return false;
        }
      }
    }

    /**
     * @param \DateTime $bookedInToDate
     * @return \Eurostop\Stocks\GetAdviceNotesByBookedInDate
     */
    public function setBookedInToDate(\DateTime $bookedInToDate)
    {
      $this->bookedInToDate = $bookedInToDate->format(\DateTime::ATOM);
      return $this;
    }

    /**
     * @return AdviceNoteStatus
     */
    public function getStatus()
    {
      return $this->status;
    }

    /**
     * @param AdviceNoteStatus $status
     * @return \Eurostop\Stocks\GetAdviceNotesByBookedInDate
     */
    public function setStatus($status)
    {
      $this->status = $status;
      return $this;
    }

    /**
     * @return boolean
     */
    public function getIsClosed()
    {
      return $this->isClosed;
    }

    /**
     * @param boolean $isClosed
     * @return \Eurostop\Stocks\GetAdviceNotesByBookedInDate
     */
    public function setIsClosed($isClosed)
    {
      $this->isClosed = $isClosed;
      return $this;
    }

}
