<?php

namespace Eurostop\Stocks;

class GetAdviceNoteByIdentifier
{

    /**
     * @var string $adviceNoteIdentifier
     */
    protected $adviceNoteIdentifier = null;

    /**
     * @var AdviceNoteIdentifierType $adviceNoteIdentifierType
     */
    protected $adviceNoteIdentifierType = null;

    /**
     * @param string $adviceNoteIdentifier
     * @param AdviceNoteIdentifierType $adviceNoteIdentifierType
     */
    public function __construct($adviceNoteIdentifier, $adviceNoteIdentifierType)
    {
      $this->adviceNoteIdentifier = $adviceNoteIdentifier;
      $this->adviceNoteIdentifierType = $adviceNoteIdentifierType;
    }

    /**
     * @return string
     */
    public function getAdviceNoteIdentifier()
    {
      return $this->adviceNoteIdentifier;
    }

    /**
     * @param string $adviceNoteIdentifier
     * @return \Eurostop\Stocks\GetAdviceNoteByIdentifier
     */
    public function setAdviceNoteIdentifier($adviceNoteIdentifier)
    {
      $this->adviceNoteIdentifier = $adviceNoteIdentifier;
      return $this;
    }

    /**
     * @return AdviceNoteIdentifierType
     */
    public function getAdviceNoteIdentifierType()
    {
      return $this->adviceNoteIdentifierType;
    }

    /**
     * @param AdviceNoteIdentifierType $adviceNoteIdentifierType
     * @return \Eurostop\Stocks\GetAdviceNoteByIdentifier
     */
    public function setAdviceNoteIdentifierType($adviceNoteIdentifierType)
    {
      $this->adviceNoteIdentifierType = $adviceNoteIdentifierType;
      return $this;
    }

}
